/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.arguments;

import com.wynntils.core.consumers.functions.arguments.Argument;
import java.util.List;

public class ListArgument<T>
extends Argument<List> {
    private final Class<T> innerType;

    public ListArgument(String name, Class<T> innerType) {
        super(name, List.class, null, false);
        if (!SUPPORTED_ARGUMENT_TYPES.contains(innerType)) {
            throw new IllegalArgumentException("Unsupported inner argument type: " + String.valueOf(innerType));
        }
        this.innerType = innerType;
    }

    public Class<T> getInnerType() {
        return this.innerType;
    }

    @Override
    public <U> List<U> getList(Class<U> assumedType) {
        if (!assumedType.equals(this.innerType)) {
            throw new IllegalStateException("List argument is not a " + assumedType.getSimpleName() + ".");
        }
        return this.getValueChecked(List.class);
    }
}

