/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.screens;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.CrashReport;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class WynntilsScreen
extends Screen
implements TextboxScreen {
    private TextInputBoxWidget focusedTextInput;

    protected WynntilsScreen(Component component) {
        super(component);
    }

    private void failure(String method, Throwable throwable) {
        McUtils.mc().setScreen(null);
        WynntilsMod.reportCrash(CrashType.SCREEN, this.getClass().getSimpleName(), this.getClass().getName(), method, true, false, throwable);
        McUtils.sendErrorToClient("Screen was forcefully closed.");
    }

    public final void init() {
        try {
            this.doInit();
        }
        catch (Throwable t) {
            this.failure("init", t);
        }
    }

    protected void doInit() {
        super.init();
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        try {
            this.doRender(guiGraphics, mouseX, mouseY, partialTick);
        }
        catch (Throwable t) {
            this.failure("render", t);
        }
    }

    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (McUtils.mc().level == null) {
            this.renderPanorama(guiGraphics, partialTick);
        }
        this.renderBlurredBackground();
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            return this.doMouseClicked(mouseX, mouseY, button);
        }
        catch (Throwable t) {
            this.failure("mouseClicked", t);
            return false;
        }
    }

    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void wrapCurrentScreenError(CrashReport crashReport) {
        this.failure(crashReport.getDetails(), crashReport.getException());
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.focusedTextInput;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.focusedTextInput = focusedTextInput;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.getFocusedTextInput() != null && this.getFocusedTextInput().charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            Object e;
            int actualIndex;
            int i;
            int index = this.getFocusedTextInput() == null ? 0 : this.children().indexOf((Object)this.getFocusedTextInput());
            for (i = actualIndex = Math.max(index, 0) + 1; i < this.children().size(); ++i) {
                e = this.children().get(i);
                if (!(e instanceof TextInputBoxWidget)) continue;
                TextInputBoxWidget textInputBoxWidget = (TextInputBoxWidget)((Object)e);
                this.setFocusedTextInput(textInputBoxWidget);
                return true;
            }
            for (i = 0; i < Math.min(actualIndex, this.children().size()); ++i) {
                e = this.children().get(i);
                if (!(e instanceof TextInputBoxWidget)) continue;
                TextInputBoxWidget textInputBoxWidget = (TextInputBoxWidget)((Object)e);
                this.setFocusedTextInput(textInputBoxWidget);
                return true;
            }
        }
        if (this.getFocusedTextInput() != null) {
            return this.getFocusedTextInput().keyPressed(keyCode, scanCode, modifiers);
        }
        if (this instanceof WrappedScreen && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

