/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.keybinds;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.world.inventory.Slot;

public class KeyBind {
    private static final String CATEGORY = "Wynntils";
    private final Runnable onPress;
    private final Consumer<Slot> onInventoryPress;
    private final boolean firstPress;
    private final KeyMapping keyMapping;
    private boolean isPressed = false;

    public KeyBind(String name, int keyCode, boolean firstPress, Runnable onPress, Consumer<Slot> onInventoryPress) {
        this.firstPress = firstPress;
        this.keyMapping = new KeyMapping(name, InputConstants.Type.KEYSYM, keyCode, CATEGORY);
        this.keyMapping.setKey(InputConstants.UNKNOWN);
        KeyMapping.resetMapping();
        this.onPress = onPress;
        this.onInventoryPress = onInventoryPress;
    }

    public KeyBind(String name, int keyCode, InputConstants.Type type, boolean firstPress, Runnable onPress, Consumer<Slot> onInventoryPress) {
        this.firstPress = firstPress;
        this.keyMapping = new KeyMapping(name, type, keyCode, CATEGORY);
        this.keyMapping.setKey(InputConstants.UNKNOWN);
        KeyMapping.resetMapping();
        this.onPress = onPress;
        this.onInventoryPress = onInventoryPress;
    }

    public KeyBind(String name, int keyCode, InputConstants.Type type, boolean firstPress, Runnable onPress) {
        this.firstPress = firstPress;
        this.keyMapping = new KeyMapping(name, type, keyCode, CATEGORY);
        this.keyMapping.setKey(InputConstants.UNKNOWN);
        KeyMapping.resetMapping();
        this.onPress = onPress;
        this.onInventoryPress = null;
    }

    public KeyBind(String name, int keyCode, boolean firstPress, Runnable onPress) {
        this(name, keyCode, firstPress, onPress, null);
    }

    public boolean onlyFirstPress() {
        return this.firstPress;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void setIsPressed(boolean isPressed) {
        this.isPressed = isPressed;
    }

    public KeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public void onPress() {
        if (this.onPress == null) {
            return;
        }
        this.onPress.run();
    }

    public void onInventoryPress(Slot hoveredSlot) {
        if (this.onInventoryPress == null) {
            return;
        }
        this.onInventoryPress.accept(hoveredSlot);
    }

    public String getName() {
        return this.keyMapping.getName();
    }

    public String getCategory() {
        return this.keyMapping.getCategory();
    }

    public String toString() {
        return "'" + this.getName() + "' [" + this.getKeyMapping().getTranslatedKeyMessage().getString() + "]";
    }
}

