/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.keybinds;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.mc.event.InventoryKeyPressEvent;
import com.wynntils.mc.event.InventoryMouseClickedEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.mixin.accessors.OptionsAccessor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class KeyBindManager
extends Manager {
    private final Set<KeyBind> enabledKeyBinds = ConcurrentHashMap.newKeySet();
    private final Map<Feature, List<Pair<KeyBind, String>>> keyBinds = new ConcurrentHashMap<Feature, List<Pair<KeyBind, String>>>();

    public KeyBindManager() {
        super(List.of());
    }

    public void discoverKeyBinds(Feature feature) {
        for (Field f : FieldUtils.getFieldsWithAnnotation(feature.getClass(), RegisterKeyBind.class)) {
            if (!f.getType().equals(KeyBind.class)) continue;
            try {
                KeyBind keyBind = (KeyBind)FieldUtils.readField((Field)f, (Object)feature, (boolean)true);
                this.keyBinds.putIfAbsent(feature, new LinkedList());
                this.keyBinds.get(feature).add(Pair.of(keyBind, f.getName()));
            }
            catch (Exception e) {
                WynntilsMod.error("Failed to register KeyBind " + f.getName() + " in " + feature.getClass().getName(), e);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        this.triggerKeybinds();
    }

    @SubscribeEvent
    public void onKeyPress(InventoryKeyPressEvent e) {
        this.checkAllKeyBinds(keyBind -> {
            if (keyBind.getKeyMapping().matches(e.getKeyCode(), e.getScanCode())) {
                keyBind.onInventoryPress(e.getHoveredSlot());
            }
        });
    }

    @SubscribeEvent
    public void onMousePress(InventoryMouseClickedEvent e) {
        this.checkAllKeyBinds(keyBind -> {
            if (keyBind.getKeyMapping().matchesMouse(e.getButton())) {
                keyBind.onInventoryPress(e.getHoveredSlot());
            }
        });
    }

    public void enableFeatureKeyBinds(Feature feature) {
        if (!this.keyBinds.containsKey(feature)) {
            return;
        }
        for (Pair<KeyBind, String> keyBind : this.keyBinds.get(feature)) {
            this.registerKeybind(feature, keyBind.key(), keyBind.value());
        }
    }

    public void disableFeatureKeyBinds(Feature feature) {
        if (!this.keyBinds.containsKey(feature)) {
            return;
        }
        for (Pair<KeyBind, String> keyBind : this.keyBinds.get(feature)) {
            this.unregisterKeybind(feature, keyBind.key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerKeybind(Feature parent, KeyBind toAdd, String fieldName) {
        if (this.hasName(toAdd.getName())) {
            throw new IllegalStateException("Can not add keybind " + toAdd.getName() + " since the name already exists");
        }
        KeyMapping keyMapping = toAdd.getKeyMapping();
        Options options = McUtils.options();
        synchronized (options) {
            this.enabledKeyBinds.add(toAdd);
            Options options2 = McUtils.options();
            Object[] keyMappings = options2.keyMappings;
            ArrayList newKeyMappings = Lists.newArrayList((Object[])keyMappings);
            newKeyMappings.add(keyMapping);
            ((OptionsAccessor)options2).setKeyBindMixins((KeyMapping[])newKeyMappings.toArray(KeyMapping[]::new));
        }
        keyMapping.setKey(keyMapping.getDefaultKey());
        KeyMapping.resetMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterKeybind(Feature parent, KeyBind toRemove) {
        if (!this.enabledKeyBinds.remove(toRemove)) {
            return;
        }
        KeyMapping keyMapping = toRemove.getKeyMapping();
        Options options = McUtils.options();
        synchronized (options) {
            Options options2 = McUtils.options();
            Object[] keyMappings = options2.keyMappings;
            ArrayList newKeyMappings = Lists.newArrayList((Object[])keyMappings);
            newKeyMappings.remove(toRemove.getKeyMapping());
            ((OptionsAccessor)options2).setKeyBindMixins((KeyMapping[])newKeyMappings.toArray(KeyMapping[]::new));
        }
        keyMapping.setKey(InputConstants.UNKNOWN);
        KeyMapping.resetMapping();
    }

    private void triggerKeybinds() {
        this.checkAllKeyBinds(keyBind -> {
            if (keyBind.onlyFirstPress()) {
                if (keyBind.getKeyMapping().isDown() && !keyBind.isPressed()) {
                    keyBind.onPress();
                }
                keyBind.setIsPressed(keyBind.getKeyMapping().isDown());
            } else if (keyBind.getKeyMapping().isDown()) {
                keyBind.onPress();
            }
        });
    }

    private void checkAllKeyBinds(Consumer<KeyBind> checkKeybind) {
        if (!Managers.Connection.onServer()) {
            return;
        }
        LinkedList<Pair<Feature, KeyBind>> crashedKeyBinds = new LinkedList<Pair<Feature, KeyBind>>();
        for (Feature feature : this.keyBinds.keySet()) {
            for (Pair<KeyBind, String> keyBind : this.keyBinds.get(feature)) {
                try {
                    checkKeybind.accept(keyBind.key());
                }
                catch (Throwable t) {
                    crashedKeyBinds.add(Pair.of(feature, keyBind.key()));
                    WynntilsMod.reportCrash(CrashType.KEYBIND, keyBind.value(), feature.getClass().getName() + "." + keyBind.value(), "handling", t);
                }
            }
        }
        for (Pair pair : crashedKeyBinds) {
            this.unregisterKeybind((Feature)pair.key(), (KeyBind)pair.value());
        }
    }

    private boolean hasName(String name) {
        return this.enabledKeyBinds.stream().anyMatch(k -> k.getName().equals(name));
    }

    public static void initKeyMapping(String category, Map<String, Integer> categorySortOrder) {
        if (categorySortOrder.containsKey(category)) {
            return;
        }
        int max = 0;
        for (int val : categorySortOrder.values()) {
            if (val <= max) continue;
            max = val;
        }
        categorySortOrder.put(category, max + 1);
    }
}

