/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.text.FontLookup;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.wynn.WynnUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public final class StyledTextPart {
    private final String text;
    private final PartStyle style;
    private final StyledText parent;

    public StyledTextPart(String text, Style style, StyledText parent, Style parentStyle) {
        this.parent = parent;
        this.text = text;
        this.style = PartStyle.fromStyle(style, this, parentStyle);
    }

    StyledTextPart(StyledTextPart part, StyledText parent) {
        this.text = part.text;
        this.style = new PartStyle(part.style, this);
        this.parent = parent;
    }

    private StyledTextPart(StyledTextPart part, PartStyle style, StyledText parent) {
        this.text = part.text;
        this.style = style;
        this.parent = parent;
    }

    static List<StyledTextPart> fromCodedString(String codedString, Style style, StyledText parent, Style parentStyle) {
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        Style currentStyle = style;
        StringBuilder currentString = new StringBuilder();
        boolean nextIsFormatting = false;
        StringBuilder hexColorFormatting = new StringBuilder();
        boolean clickEventPrefix = false;
        boolean hoverEventPrefix = false;
        boolean specialPrefix = false;
        StringBuilder specialString = new StringBuilder();
        Object eventIndexString = "";
        for (char current : codedString.toCharArray()) {
            if (nextIsFormatting) {
                nextIsFormatting = false;
                if (parent != null) {
                    if (current == '[') {
                        clickEventPrefix = true;
                        continue;
                    }
                    if (current == '<') {
                        hoverEventPrefix = true;
                        continue;
                    }
                }
                if (current == '{') {
                    specialPrefix = true;
                    continue;
                }
                if (current == '#') {
                    hexColorFormatting.append(current);
                    continue;
                }
                ChatFormatting formatting = ChatFormatting.getByCode((char)current);
                if (formatting == null) {
                    currentString.append('\u00a7');
                    currentString.append(current);
                    continue;
                }
                if (!currentString.isEmpty()) {
                    if (style != Style.EMPTY) {
                        currentStyle = currentStyle.withClickEvent(style.getClickEvent()).withHoverEvent(style.getHoverEvent());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
                    currentString = new StringBuilder();
                }
                if (formatting.isColor()) {
                    currentStyle = Style.EMPTY.withColor(formatting);
                    continue;
                }
                currentStyle = currentStyle.applyFormat(formatting);
                continue;
            }
            if (specialPrefix) {
                String fontCode;
                ResourceLocation font;
                if (current != '}') {
                    specialString.append(current);
                    continue;
                }
                specialPrefix = false;
                String special = specialString.toString();
                specialString = new StringBuilder();
                if (!special.startsWith("f:")) continue;
                if (!currentString.isEmpty()) {
                    if (style != Style.EMPTY) {
                        currentStyle = currentStyle.withClickEvent(style.getClickEvent()).withHoverEvent(style.getHoverEvent());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
                    currentString = new StringBuilder();
                }
                if ((font = FontLookup.getFontFromFromFontCode(fontCode = special.substring(2))) == null) continue;
                currentStyle = currentStyle.withFont(font);
                continue;
            }
            if (clickEventPrefix || hoverEventPrefix) {
                HoverEvent hoverEvent;
                ClickEvent clickEvent;
                if (Character.isDigit(current)) {
                    eventIndexString = (String)eventIndexString + current;
                    continue;
                }
                Style oldStyle = null;
                if (clickEventPrefix && current == ']' && (clickEvent = parent.getClickEvent(Integer.parseInt((String)eventIndexString))) != null) {
                    oldStyle = currentStyle;
                    currentStyle = currentStyle.withClickEvent(clickEvent);
                    clickEventPrefix = false;
                    eventIndexString = "";
                }
                if (hoverEventPrefix && current == '>' && (hoverEvent = parent.getHoverEvent(Integer.parseInt((String)eventIndexString))) != null) {
                    oldStyle = currentStyle;
                    currentStyle = currentStyle.withHoverEvent(hoverEvent);
                    hoverEventPrefix = false;
                    eventIndexString = "";
                }
                if (oldStyle != null) {
                    if (currentString.isEmpty()) continue;
                    if (style != Style.EMPTY) {
                        currentStyle = currentStyle.withClickEvent(style.getClickEvent()).withHoverEvent(style.getHoverEvent());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), oldStyle, null, parentStyle));
                    currentString = new StringBuilder();
                    continue;
                }
                currentString.append(clickEventPrefix ? (char)'[' : '<');
                currentString.append((String)eventIndexString);
                currentString.append(current);
                clickEventPrefix = false;
                hoverEventPrefix = false;
                eventIndexString = "";
                continue;
            }
            if (!hexColorFormatting.isEmpty()) {
                hexColorFormatting.append(current);
                if (hexColorFormatting.length() != 9) continue;
                CustomColor customColor = CustomColor.fromHexString(hexColorFormatting.toString());
                if (customColor == CustomColor.NONE) {
                    currentString.append((CharSequence)hexColorFormatting);
                } else if (!currentString.isEmpty()) {
                    if (style != Style.EMPTY) {
                        currentStyle = currentStyle.withClickEvent(style.getClickEvent()).withHoverEvent(style.getHoverEvent());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
                    currentString = new StringBuilder();
                }
                currentStyle = currentStyle.withColor(customColor.asInt());
                hexColorFormatting = new StringBuilder();
                continue;
            }
            if (current == '\u00a7') {
                nextIsFormatting = true;
                continue;
            }
            currentString.append(current);
        }
        if (!currentString.isEmpty()) {
            if (style != Style.EMPTY) {
                currentStyle = currentStyle.withClickEvent(style.getClickEvent()).withHoverEvent(style.getHoverEvent());
            }
            parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
        }
        return parts;
    }

    static List<StyledTextPart> fromJson(JsonArray jsonArray) {
        if (jsonArray.isEmpty()) {
            return List.of(new StyledTextPart("", Style.EMPTY, null, Style.EMPTY));
        }
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        for (JsonElement element : jsonArray) {
            if (!element.isJsonObject()) continue;
            Style style = Style.EMPTY;
            JsonObject jsonObject = element.getAsJsonObject();
            Object text = jsonObject.get("text").getAsString();
            if (jsonObject.has("bold")) {
                style = style.withBold(Boolean.valueOf(true));
            }
            if (jsonObject.has("italic")) {
                style = style.withItalic(Boolean.valueOf(true));
            }
            if (jsonObject.has("underline")) {
                style = style.withUnderlined(Boolean.valueOf(true));
            }
            if (jsonObject.has("strikethrough")) {
                style = style.withStrikethrough(Boolean.valueOf(true));
            }
            if (jsonObject.has("font")) {
                style = style.withFont(ResourceLocation.withDefaultNamespace((String)jsonObject.get("font").getAsString()));
            }
            if (jsonObject.has("color")) {
                style = style.withColor(CustomColor.fromHexString(jsonObject.get("color").getAsString()).asInt());
            }
            if (jsonObject.has("margin-left")) {
                String marginType = jsonObject.get("margin-left").getAsString();
                if (marginType.equals("thin")) {
                    text = "\u00c0" + (String)text;
                } else if (marginType.equals("large")) {
                    text = "\u00c0\u00c0\u00c0\u00c0" + (String)text;
                }
            }
            parts.add(new StyledTextPart((String)text, style, null, Style.EMPTY));
        }
        return parts;
    }

    public String getString(PartStyle previousStyle, StyleType type) {
        return this.style.asString(previousStyle, type) + this.text;
    }

    public StyledText getParent() {
        return this.parent;
    }

    public PartStyle getPartStyle() {
        return this.style;
    }

    public StyledTextPart withStyle(PartStyle style) {
        return new StyledTextPart(this, style, this.parent);
    }

    public StyledTextPart withStyle(Function<PartStyle, PartStyle> function) {
        return this.withStyle(function.apply(this.style));
    }

    public MutableComponent getComponent() {
        return Component.literal((String)this.text).withStyle(this.style.getStyle());
    }

    StyledTextPart asNormalized() {
        return new StyledTextPart(WynnUtils.normalizeBadString(this.text), this.style.getStyle(), this.parent, null);
    }

    StyledTextPart stripLeading() {
        return new StyledTextPart(this.text.stripLeading(), this.style.getStyle(), this.parent, null);
    }

    StyledTextPart stripTrailing() {
        return new StyledTextPart(this.text.stripTrailing(), this.style.getStyle(), this.parent, null);
    }

    boolean isEmpty() {
        return this.text.isEmpty();
    }

    boolean isBlank() {
        return this.text.isBlank();
    }

    public int length() {
        return this.text.length();
    }

    public String toString() {
        return "StyledTextPart[text=" + this.text + ", style=" + String.valueOf(this.style) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyledTextPart that = (StyledTextPart)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.style, that.style);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.style);
    }
}

