/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.models.worlds.type.BombInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class BombBellRelayFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind relayPartyKeybind = new KeyBind("Relay Bomb to Party", -1, true, () -> this.relayTo("p"));
    @RegisterKeyBind
    private final KeyBind relayGuildKeybind = new KeyBind("Relay Bomb to Guild", -1, true, () -> this.relayTo("g"));
    @Persisted
    private final Config<Boolean> showTime = new Config<Boolean>(true);

    private String getAndFormatLastBomb() {
        BombInfo lastBomb = Models.Bomb.getLastBomb();
        if (lastBomb == null) {
            return null;
        }
        String bombMessage = lastBomb.bomb().getDisplayName() + " bomb on " + lastBomb.server();
        if (((Boolean)this.showTime.get()).booleanValue()) {
            bombMessage = bombMessage + " with " + lastBomb.getRemainingString() + " remaining";
        }
        return bombMessage;
    }

    private void relayTo(String prefix) {
        String lastBomb = this.getAndFormatLastBomb();
        if (lastBomb == null) {
            Managers.Notification.queueMessage((Component)Component.translatable((String)"feature.wynntils.bombBellRelay.noKnownBombs").withStyle(ChatFormatting.DARK_RED));
            return;
        }
        Handlers.Command.sendCommandImmediately(prefix + " " + lastBomb);
    }
}

