/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.google.common.collect.Sets;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.mc.event.ChatScreenCreateEvent;
import com.wynntils.mc.event.ChatScreenSendEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.screens.chattabs.ChatTabsScreen;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class ChatTabsFeature
extends Feature {
    @Persisted
    public final HiddenConfig<List<ChatTab>> chatTabs = new HiddenConfig<ArrayList<ChatTab>>(new ArrayList<ChatTab>(List.of(new ChatTab("All", false, null, null, null), new ChatTab("Global", false, null, Sets.newHashSet((Object[])new RecipientType[]{RecipientType.GLOBAL}), null), new ChatTab("Local", false, null, Sets.newHashSet((Object[])new RecipientType[]{RecipientType.LOCAL}), null), new ChatTab("Guild", false, "/g  ", Sets.newHashSet((Object[])new RecipientType[]{RecipientType.GUILD}), null), new ChatTab("Party", false, "/p  ", Sets.newHashSet((Object[])new RecipientType[]{RecipientType.PARTY}), null), new ChatTab("Private", false, "/r  ", Sets.newHashSet((Object[])new RecipientType[]{RecipientType.PRIVATE}), null), new ChatTab("Shout", false, null, Sets.newHashSet((Object[])new RecipientType[]{RecipientType.SHOUT}), null))));
    @Persisted
    private final Config<Boolean> oldTabHotkey = new Config<Boolean>(false);

    @SubscribeEvent
    public void onChatScreenCreate(ChatScreenCreateEvent event) {
        event.setScreen((Screen)new ChatTabsScreen(event.getDefaultText(), (Boolean)this.oldTabHotkey.get()));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.NOT_CONNECTED) {
            Services.ChatTab.disable();
            return;
        }
        if (!Services.ChatTab.isEnabled()) {
            Services.ChatTab.enable();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatScreenSend(ChatScreenSendEvent event) {
        Services.ChatTab.sendChat(event.getInput());
        event.setCanceled(true);
    }

    @Override
    public void onEnable() {
        Services.ChatTab.setChatTabs((List)this.chatTabs.get());
        Services.ChatTab.enable();
        Screen screen = McUtils.mc().screen;
        if (screen instanceof ChatScreen) {
            ChatScreen chatScreen = (ChatScreen)screen;
            if (screen instanceof ChatTabsScreen) {
                return;
            }
            McUtils.mc().setScreen((Screen)new ChatTabsScreen("", (Boolean)this.oldTabHotkey.get()));
        }
    }

    @Override
    public void onDisable() {
        Services.ChatTab.disable();
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        Services.ChatTab.setChatTabs((List)this.chatTabs.get());
    }
}

