/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.GroundItemEntityTransformEvent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class MythicBoxScalerFeature
extends Feature {
    private static final String MYTHIC_BOX_CUSTOM_MODEL_DATA_KEY = "mythic_box";
    @Persisted
    private final Config<Float> scale = new Config<Float>(Float.valueOf(1.5f));

    @SubscribeEvent
    public void onItemRendering(GroundItemEntityTransformEvent e) {
        if (!this.isMythicBox(e.getItemStack())) {
            return;
        }
        PoseStack stack = e.getPoseStack();
        stack.translate(0.0f, -0.25f, 0.0f);
        stack.scale(((Float)this.scale.get()).floatValue(), ((Float)this.scale.get()).floatValue(), ((Float)this.scale.get()).floatValue());
        stack.translate(0.0f, 0.25f, 0.0f);
    }

    private boolean isMythicBox(ItemStack itemStack) {
        return itemStack.is(Items.POTION) && itemStack.has(DataComponents.CUSTOM_MODEL_DATA) && ((CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA)).floats().contains(Services.CustomModel.getFloat(MYTHIC_BOX_CUSTOM_MODEL_DATA_KEY).orElse(Float.valueOf(-1.0f)));
    }
}

