/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PlayerRenderEvent;
import com.wynntils.mc.event.RenderTileLevelLastEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.extension.EntityRenderStateExtension;
import com.wynntils.models.gambits.type.Gambit;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.buffered.CustomRenderType;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Matrix4f;

@ConfigCategory(value=Category.COMBAT)
public class RangeVisualizerFeature
extends Feature {
    private static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    private static final int SEGMENTS = 128;
    private static final float HEIGHT = 0.1f;
    private static final int TRANSPARENCY = 95;
    private final Map<Player, List<Pair<CustomColor, Float>>> circlesToRender = new HashMap<Player, List<Pair<CustomColor, Float>>>();
    private final Set<Player> detectedPlayers = new HashSet<Player>();
    @Persisted
    private final Config<Boolean> renderInFirstPerson = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showGambitCircles = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showMajorIDCircles = new Config<Boolean>(true);

    @SubscribeEvent
    public void onPlayerRender(PlayerRenderEvent e) {
        Entity entity = ((EntityRenderStateExtension)e.getPlayerRenderState()).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        if (player.equals((Object)McUtils.player()) && ((Boolean)this.renderInFirstPerson.get()).booleanValue()) {
            return;
        }
        this.detectedPlayers.add((Player)player);
        List<Pair<CustomColor, Float>> circles = this.circlesToRender.get(player);
        if (circles == null) {
            return;
        }
        circles.forEach(circleType -> {
            float radius = ((Float)circleType.b()).floatValue();
            int color = ((CustomColor)circleType.a()).asInt();
            this.renderCircle(e.getPoseStack(), (Position)player.position(), radius, color);
        });
    }

    @SubscribeEvent
    public void onRenderLevelLast(RenderTileLevelLastEvent event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (!((Boolean)this.renderInFirstPerson.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = McUtils.player();
        if (player == null) {
            return;
        }
        this.detectedPlayers.add((Player)player);
        List<Pair<CustomColor, Float>> circles = this.circlesToRender.get(player);
        if (circles == null || circles.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        float partialTick = event.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        double interpX = player.xo + (player.getX() - player.xo) * (double)partialTick;
        double interpY = player.yo + (player.getY() - player.yo) * (double)partialTick;
        double interpZ = player.zo + (player.getZ() - player.zo) * (double)partialTick;
        poseStack.pushPose();
        poseStack.translate(interpX - event.getCamera().getPosition().x, interpY - event.getCamera().getPosition().y, interpZ - event.getCamera().getPosition().z);
        for (Pair<CustomColor, Float> circle : circles) {
            float radius = circle.b().floatValue();
            int color = circle.a().asInt();
            this.renderCircle(poseStack, (Position)player.position(), radius, color);
        }
        poseStack.popPose();
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        this.circlesToRender.clear();
        this.detectedPlayers.forEach(this::checkCircles);
        this.detectedPlayers.clear();
    }

    private void checkCircles(Player player) {
        if (!Models.Player.isLocalPlayer(player)) {
            return;
        }
        ArrayList circles = new ArrayList();
        if (((Boolean)this.showMajorIDCircles.get()).booleanValue()) {
            List<GearInfo> validGear;
            if (player == McUtils.player()) {
                if (McUtils.mc().screen != null && !(McUtils.mc().screen instanceof ChatScreen)) {
                    return;
                }
                validGear = Models.CharacterStats.getWornGear();
            } else {
                Optional<HadesUser> hadesUserOpt = Services.Hades.getHadesUser(player.getUUID());
                if (hadesUserOpt.isEmpty()) {
                    return;
                }
                validGear = new ArrayList<GearInfo>();
                GearInfo heldItemGearInfo = this.getOtherPlayerGearInfo(hadesUserOpt.get().getHeldItem());
                if (heldItemGearInfo != null && heldItemGearInfo.type().isWeapon()) {
                    validGear.add(heldItemGearInfo);
                }
                for (InventoryArmor armor : hadesUserOpt.get().getArmor().keySet()) {
                    GearInfo armorGearInfo = this.getOtherPlayerGearInfo((WynnItem)hadesUserOpt.get().getArmor().get((Object)armor));
                    if (armorGearInfo == null || !armorGearInfo.type().isArmor()) continue;
                    validGear.add(armorGearInfo);
                }
                for (InventoryAccessory accessory : hadesUserOpt.get().getAccessories().keySet()) {
                    GearInfo accessoryGearInfo = this.getOtherPlayerGearInfo((WynnItem)hadesUserOpt.get().getAccessories().get((Object)accessory));
                    if (accessoryGearInfo == null || !accessoryGearInfo.type().isAccessory()) continue;
                    validGear.add(accessoryGearInfo);
                }
            }
            validGear.stream().flatMap(gearInfo -> gearInfo.fixedStats().majorIds().stream().map(majorId -> this.getCircleFromMajorId(majorId.name()))).filter(Objects::nonNull).forEach(circles::add);
        }
        if (Models.Raid.getCurrentRaid() != null) {
            if (player == McUtils.player() && ((Boolean)this.showGambitCircles.get()).booleanValue()) {
                Models.Gambit.getActiveGambits().stream().map(this::getCircleFromGambit).filter(Objects::nonNull).forEach(circles::add);
            }
            if (((Boolean)this.showMajorIDCircles.get()).booleanValue()) {
                Models.Raid.getRaidMajorIds(player.getName().getString()).stream().map(this::getCircleFromMajorId).filter(Objects::nonNull).forEach(circles::add);
            }
        }
        if (!circles.isEmpty()) {
            this.circlesToRender.put(player, circles);
        }
    }

    private Pair<CustomColor, Float> getCircleFromMajorId(String majorIdName) {
        return switch (majorIdName) {
            case "Taunt" -> Pair.of(CommonColors.ORANGE.withAlpha(95), Float.valueOf(12.0f));
            case "Saviour's Sacrifice" -> Pair.of(CommonColors.WHITE.withAlpha(95), Float.valueOf(8.0f));
            case "Altruism" -> Pair.of(CommonColors.PINK.withAlpha(95), Float.valueOf(16.0f));
            case "Guardian" -> Pair.of(CommonColors.RED.withAlpha(95), Float.valueOf(12.0f));
            default -> null;
        };
    }

    private Pair<CustomColor, Float> getCircleFromGambit(Gambit gambit) {
        return switch (gambit) {
            case Gambit.FARSIGHTED -> Pair.of(CommonColors.RED.withAlpha(95), Float.valueOf(3.0f));
            case Gambit.MYOPIC -> Pair.of(CommonColors.RED.withAlpha(95), Float.valueOf(12.0f));
            default -> null;
        };
    }

    private GearInfo getOtherPlayerGearInfo(WynnItem wynnItem) {
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return gearItem.getItemInfo();
        }
        return null;
    }

    private void renderCircle(PoseStack poseStack, Position position, float radius, int color) {
        double startingAngle;
        RenderSystem.disableCull();
        poseStack.pushPose();
        poseStack.translate(-position.x(), -position.y(), -position.z());
        VertexConsumer consumer = BUFFER_SOURCE.getBuffer(CustomRenderType.POSITION_COLOR_QUAD);
        Matrix4f matrix4f = poseStack.last().pose();
        double angleStep = 0.04908738521234052;
        double angle = startingAngle = (double)(-(System.currentTimeMillis() % 40000L) * 2L) * Math.PI / 40000.0;
        for (int i = 0; i < 128; ++i) {
            if (i % 4 > 2) {
                angle += angleStep;
                continue;
            }
            float x = (float)(position.x() + Math.sin(angle) * (double)radius);
            float z = (float)(position.z() + Math.cos(angle) * (double)radius);
            consumer.addVertex(matrix4f, x, (float)position.y(), z).setColor(color);
            consumer.addVertex(matrix4f, x, (float)position.y() + 0.1f, z).setColor(color);
            float x2 = (float)(position.x() + Math.sin(angle += angleStep) * (double)radius);
            float z2 = (float)(position.z() + Math.cos(angle) * (double)radius);
            consumer.addVertex(matrix4f, x2, (float)position.y() + 0.1f, z2).setColor(color);
            consumer.addVertex(matrix4f, x2, (float)position.y(), z2).setColor(color);
        }
        BUFFER_SOURCE.endBatch();
        poseStack.popPose();
        RenderSystem.enableCull();
    }
}

