/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.CommandsAddedEvent;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMMANDS)
public class AddCommandExpansionFeature
extends Feature {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.Player.getAllPlayerNames(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> FRIEND_NAME_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.Friends.getFriends(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> PARTY_NAME_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.Party.getPartyMembers().stream().filter(p -> !p.equals(McUtils.playerName())), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SERVERS_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.ServerList.getServers(), (SuggestionsBuilder)builder);
    @Persisted
    private final Config<Boolean> includeDeprecatedCommands = new Config<Boolean>(false);
    @Persisted
    private final Config<AliasCommandLevel> includeAliases = new Config<AliasCommandLevel>(AliasCommandLevel.SHORT_FORMS);

    @SubscribeEvent
    public void onCommandPacket(CommandsAddedEvent event) {
        RootCommandNode<SharedSuggestionProvider> root = event.getRoot();
        this.addArgumentlessCommandNodes(root);
        this.addChangetagCommandNode(root);
        this.addEmoteCommandNode(root);
        this.addFriendCommandNode(root);
        this.addGuildCommandNode(root);
        this.addIgnoreCommandNode(root);
        this.addHousingCommandNode(root);
        this.addMessagingCommandNodes(root);
        this.addMiscCommandNodes(root);
        this.addParticlesCommandNode(root);
        this.addPartyCommandNode(root);
        this.addPlayerCommandNodes(root);
        this.addToggleCommandNode(root);
        if (((Boolean)this.includeDeprecatedCommands.get()).booleanValue()) {
            this.addDeprecatedCommandNodes(root);
        }
    }

    private void addNode(RootCommandNode<SharedSuggestionProvider> root, CommandNode<? extends SharedSuggestionProvider> node) {
        Managers.Command.addNode(root, node);
    }

    private void addAlias(RootCommandNode<SharedSuggestionProvider> root, CommandNode<CommandSourceStack> originalNode, String aliasName, AliasCommandLevel level) {
        if (((AliasCommandLevel)((Object)this.includeAliases.get())).ordinal() >= level.ordinal()) {
            this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)aliasName).redirect(originalNode)).build());
        }
    }

    private void addArgumentlessCommandNodes(RootCommandNode<SharedSuggestionProvider> root) {
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"claimingredientbomb").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"claimitembomb").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"daily").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"fixquests").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"fixstart").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"forum").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"help").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"link").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"rules").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"sign").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"skiptutorial").build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"tracking").build());
        LiteralCommandNode hubNode = Commands.literal((String)"hub").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)hubNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)hubNode, "change", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)hubNode, "lobby", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)hubNode, "leave", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)hubNode, "port", AliasCommandLevel.ALL);
        LiteralCommandNode classNode = Commands.literal((String)"class").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)classNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)classNode, "classes", AliasCommandLevel.ALL);
        LiteralCommandNode charactersNode = Commands.literal((String)"characters").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)charactersNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)charactersNode, "char", AliasCommandLevel.ALL);
        LiteralCommandNode crateNode = Commands.literal((String)"crate").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)crateNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)crateNode, "crates", AliasCommandLevel.ALL);
        LiteralCommandNode disguisesNode = Commands.literal((String)"disguises").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)disguisesNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)disguisesNode, "disguise", AliasCommandLevel.ALL);
        LiteralCommandNode effectsNode = Commands.literal((String)"effects").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)effectsNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)effectsNode, "effect", AliasCommandLevel.ALL);
        LiteralCommandNode hatsNode = Commands.literal((String)"hats").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)hatsNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)hatsNode, "hat", AliasCommandLevel.ALL);
        LiteralCommandNode mountsNode = Commands.literal((String)"mounts").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)mountsNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)mountsNode, "mount", AliasCommandLevel.ALL);
        LiteralCommandNode weaponsNode = Commands.literal((String)"weapons").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)weaponsNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)weaponsNode, "weapon", AliasCommandLevel.ALL);
        LiteralCommandNode consumablesNode = Commands.literal((String)"consumables").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)consumablesNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)consumablesNode, "bomb", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)consumablesNode, "bombs", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)consumablesNode, "token", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)consumablesNode, "tokens", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)consumablesNode, "consumable", AliasCommandLevel.ALL);
        LiteralCommandNode useNode = Commands.literal((String)"use").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)useNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)useNode, "rank", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)useNode, "shop", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)useNode, "store", AliasCommandLevel.ALL);
        LiteralCommandNode killNode = Commands.literal((String)"kill").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)killNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)killNode, "die", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)killNode, "suicide", AliasCommandLevel.ALL);
        LiteralCommandNode itemlockNode = Commands.literal((String)"itemlock").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)itemlockNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)itemlockNode, "ilock", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)itemlockNode, "lock", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)itemlockNode, "locki", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)itemlockNode, "lockitem", AliasCommandLevel.ALL);
        LiteralCommandNode petNode = Commands.literal((String)"pet").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)petNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)petNode, "pets", AliasCommandLevel.ALL);
        LiteralCommandNode partyfinderNode = Commands.literal((String)"partyfinder").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)partyfinderNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)partyfinderNode, "pfinder", AliasCommandLevel.SHORT_FORMS);
        LiteralCommandNode streamNode = Commands.literal((String)"stream").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)streamNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)streamNode, "streamer", AliasCommandLevel.ALL);
        LiteralCommandNode totemNode = Commands.literal((String)"totem").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)totemNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)totemNode, "totems", AliasCommandLevel.ALL);
        LiteralCommandNode huntedNode = Commands.literal((String)"hunted").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)huntedNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)huntedNode, "pvp", AliasCommandLevel.SHORT_FORMS);
        LiteralCommandNode recruitNode = Commands.literal((String)"recruit").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)recruitNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)recruitNode, "rf", AliasCommandLevel.ALL);
    }

    private void addChangetagCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"changetag").then((ArgumentBuilder)Commands.literal((String)"VIP"))).then((ArgumentBuilder)Commands.literal((String)"VIP+"))).then((ArgumentBuilder)Commands.literal((String)"HERO"))).then((ArgumentBuilder)Commands.literal((String)"HERO+"))).then((ArgumentBuilder)Commands.literal((String)"CHAMPION"))).then((ArgumentBuilder)Commands.literal((String)"RESET"))).build());
    }

    private void addEmoteCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emote").then((ArgumentBuilder)Commands.literal((String)"cheer"))).then((ArgumentBuilder)Commands.literal((String)"clap"))).then((ArgumentBuilder)Commands.literal((String)"dance"))).then((ArgumentBuilder)Commands.literal((String)"explode"))).then((ArgumentBuilder)Commands.literal((String)"faint"))).then((ArgumentBuilder)Commands.literal((String)"flop"))).then((ArgumentBuilder)Commands.literal((String)"hug"))).then((ArgumentBuilder)Commands.literal((String)"relax"))).then((ArgumentBuilder)Commands.literal((String)"jump"))).then((ArgumentBuilder)Commands.literal((String)"wave"))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "emotes", AliasCommandLevel.ALL);
    }

    private void addFriendCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"friend").then((ArgumentBuilder)Commands.literal((String)"list"))).then((ArgumentBuilder)Commands.literal((String)"online"))).then(Commands.literal((String)"add").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"remove").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(FRIEND_NAME_SUGGESTION_PROVIDER)))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "f", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "friends", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "buddy", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "buddies", AliasCommandLevel.ALL);
    }

    private void addGuildCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"guild").then((ArgumentBuilder)Commands.literal((String)"attack"))).then((ArgumentBuilder)Commands.literal((String)"contribute"))).then((ArgumentBuilder)Commands.literal((String)"defend"))).then(Commands.literal((String)"invite").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"join").then((ArgumentBuilder)Commands.argument((String)"tag", (ArgumentType)StringArgumentType.greedyString())))).then(Commands.literal((String)"kick").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)Commands.literal((String)"leaderboard"))).then((ArgumentBuilder)Commands.literal((String)"leave"))).then((ArgumentBuilder)Commands.literal((String)"list"))).then((ArgumentBuilder)Commands.literal((String)"log"))).then((ArgumentBuilder)Commands.literal((String)"manage"))).then(Commands.literal((String)"rank").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).then((ArgumentBuilder)Commands.argument((String)"rank", (ArgumentType)StringArgumentType.string()))))).then((ArgumentBuilder)Commands.literal((String)"rewards"))).then((ArgumentBuilder)Commands.literal((String)"stats"))).then((ArgumentBuilder)Commands.literal((String)"territory"))).then(Commands.literal((String)"xp").then((ArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer())))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "gu", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "guilds", AliasCommandLevel.ALL);
    }

    private void addIgnoreCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ignore").then(Commands.literal((String)"add").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"remove").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).build());
    }

    private void addHousingCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"housing").then(Commands.literal((String)"allowedit").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"ban").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"disallowedit").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)Commands.literal((String)"edit"))).then(Commands.literal((String)"invite").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"kick").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)Commands.literal((String)"kickall"))).then((ArgumentBuilder)Commands.literal((String)"leave"))).then((ArgumentBuilder)Commands.literal((String)"public"))).then(Commands.literal((String)"unban").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)Commands.literal((String)"visit"))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "is", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "hs", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "home", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "house", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "island", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "plot", AliasCommandLevel.ALL);
    }

    private void addMessagingCommandNodes(RootCommandNode<SharedSuggestionProvider> root) {
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"g").then((ArgumentBuilder)Commands.argument((String)"msg", (ArgumentType)StringArgumentType.greedyString()))).build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"p").then((ArgumentBuilder)Commands.argument((String)"msg", (ArgumentType)StringArgumentType.greedyString()))).build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"r").then((ArgumentBuilder)Commands.argument((String)"msg", (ArgumentType)StringArgumentType.greedyString()))).build());
        LiteralCommandNode node = ((LiteralArgumentBuilder)Commands.literal((String)"msg").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).then((ArgumentBuilder)Commands.argument((String)"msg", (ArgumentType)StringArgumentType.greedyString())))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
    }

    private void addMiscCommandNodes(RootCommandNode<SharedSuggestionProvider> root) {
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"report").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).then((ArgumentBuilder)Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString())))).build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"switch").then((ArgumentBuilder)Commands.argument((String)"world", (ArgumentType)StringArgumentType.string()).suggests(SERVERS_SUGGESTION_PROVIDER))).build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"relore").then((ArgumentBuilder)Commands.argument((String)"lore", (ArgumentType)StringArgumentType.greedyString()))).build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"dialogue").then((ArgumentBuilder)Commands.argument((String)"option", (ArgumentType)IntegerArgumentType.integer()))).build());
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"thankyou").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build());
        LiteralCommandNode renameitemNode = ((LiteralArgumentBuilder)Commands.literal((String)"renameitem").then((ArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)renameitemNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)renameitemNode, "renameitems", AliasCommandLevel.ALL);
        LiteralCommandNode renamepetNode = ((LiteralArgumentBuilder)Commands.literal((String)"renamepet").then((ArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)renamepetNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)renamepetNode, "renamepets", AliasCommandLevel.ALL);
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)Commands.literal((String)"ironman").build());
    }

    private void addParticlesCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"particles").then((ArgumentBuilder)Commands.literal((String)"off"))).then((ArgumentBuilder)Commands.literal((String)"low"))).then((ArgumentBuilder)Commands.literal((String)"medium"))).then((ArgumentBuilder)Commands.literal((String)"high"))).then((ArgumentBuilder)Commands.literal((String)"veryhigh"))).then((ArgumentBuilder)Commands.literal((String)"highest"))).then((ArgumentBuilder)Commands.literal((String)"unlimited"))).then((ArgumentBuilder)Commands.argument((String)"particles_per_tick", (ArgumentType)IntegerArgumentType.integer()))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "pq", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "particlequality", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "particlesquality", AliasCommandLevel.ALL);
    }

    private void addPartyCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"party").then(Commands.literal((String)"ban").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)Commands.literal((String)"create"))).then((ArgumentBuilder)Commands.literal((String)"disband"))).then((ArgumentBuilder)Commands.literal((String)"finder"))).then(Commands.literal((String)"invite").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"join").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"kick").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PARTY_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)Commands.literal((String)"leave"))).then((ArgumentBuilder)Commands.literal((String)"lobby"))).then((ArgumentBuilder)Commands.literal((String)"list"))).then(Commands.literal((String)"promote").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PARTY_NAME_SUGGESTION_PROVIDER)))).then(Commands.literal((String)"unban").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)node);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "pa", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<CommandSourceStack>)node, "group", AliasCommandLevel.ALL);
    }

    private void addPlayerCommandNodes(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode duelNode = ((LiteralArgumentBuilder)Commands.literal((String)"duel").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)duelNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)duelNode, "d", AliasCommandLevel.SHORT_FORMS);
        LiteralCommandNode tradeNode = ((LiteralArgumentBuilder)Commands.literal((String)"trade").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)tradeNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)tradeNode, "tr", AliasCommandLevel.SHORT_FORMS);
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)Commands.literal((String)"find").then((ArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build());
    }

    private void addToggleCommandNode(RootCommandNode<SharedSuggestionProvider> root) {
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"toggle").then((ArgumentBuilder)Commands.literal((String)"100"))).then((ArgumentBuilder)Commands.literal((String)"autotracking"))).then((ArgumentBuilder)Commands.literal((String)"beacon"))).then((ArgumentBuilder)Commands.literal((String)"blood"))).then((ArgumentBuilder)Commands.literal((String)"bombbell"))).then((ArgumentBuilder)Commands.literal((String)"combatbar"))).then((ArgumentBuilder)Commands.literal((String)"friendpopups"))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ghosts").then((ArgumentBuilder)Commands.literal((String)"none"))).then((ArgumentBuilder)Commands.literal((String)"low"))).then((ArgumentBuilder)Commands.literal((String)"medium"))).then((ArgumentBuilder)Commands.literal((String)"high"))).then((ArgumentBuilder)Commands.literal((String)"all")))).then((ArgumentBuilder)Commands.literal((String)"guildjoin"))).then((ArgumentBuilder)Commands.literal((String)"guildpopups"))).then((ArgumentBuilder)Commands.literal((String)"insults"))).then((ArgumentBuilder)Commands.literal((String)"music"))).then((ArgumentBuilder)Commands.literal((String)"outlines"))).then((ArgumentBuilder)Commands.literal((String)"popups"))).then((ArgumentBuilder)Commands.literal((String)"pouchmsg"))).then((ArgumentBuilder)Commands.literal((String)"pouchpickup"))).then((ArgumentBuilder)Commands.literal((String)"queststartbeacon"))).then((ArgumentBuilder)Commands.literal((String)"sb"))).then((ArgumentBuilder)Commands.literal((String)"swears"))).then((ArgumentBuilder)Commands.literal((String)"war"))).build());
    }

    private void addDeprecatedCommandNodes(RootCommandNode<SharedSuggestionProvider> root) {
        LiteralCommandNode legacystoreNode = Commands.literal((String)"legacystore").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)legacystoreNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "buy", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "cash", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "cashshop", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "gc", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "gold", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "goldcoins", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<CommandSourceStack>)legacystoreNode, "goldshop", AliasCommandLevel.ALL);
        LiteralCommandNode renameNode = Commands.literal((String)"rename").build();
        this.addNode(root, (CommandNode<? extends SharedSuggestionProvider>)renameNode);
        this.addAlias(root, (CommandNode<CommandSourceStack>)renameNode, "name", AliasCommandLevel.ALL);
    }

    public static enum AliasCommandLevel {
        NONE,
        SHORT_FORMS,
        ALL;

    }
}

