/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.SetSpawnEvent;
import com.wynntils.models.activities.ActivityModel;
import com.wynntils.models.activities.type.ActivityDifficulty;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityLength;
import com.wynntils.models.activities.type.ActivityRequirements;
import com.wynntils.models.activities.type.ActivityRewardType;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class ContentBookDumpFeature
extends Feature {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomColor.class, (Object)new CustomColor.CustomColorSerializer()).registerTypeAdapterFactory(new EnumUtils.EnumTypeAdapterFactory()).enableComplexMapKeySerialization().setPrettyPrinting().serializeNulls().create();
    private static final File SAVE_FOLDER = WynntilsMod.getModStorageDir("debug");
    @RegisterKeyBind
    private final KeyBind dumpContentBook = new KeyBind("Dump Content Book", -1, true, this::dumpContentBook);
    private List<DumpableActivityInfo> currentDump = List.of();
    private Location lastTrackedLocation = null;
    private DumpableActivityInfo currentlyTracking = null;
    private Queue<DumpableActivityInfo> manualTrackingRequired = new LinkedList<DumpableActivityInfo>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSetSpawn(SetSpawnEvent event) {
        if (this.currentlyTracking == null) {
            return;
        }
        Optional<Location> spawnLocationOpt = ActivityModel.ACTIVITY_MARKER_PROVIDER.getSpawnLocation();
        if (spawnLocationOpt.isEmpty()) {
            WynntilsMod.error("Could not get spawn location for " + this.currentlyTracking.name());
            return;
        }
        Location currentTracker = spawnLocationOpt.get();
        if (this.lastTrackedLocation != currentTracker) {
            this.currentDump.remove(this.currentlyTracking);
            this.currentDump.add(new DumpableActivityInfo(this.currentlyTracking.type(), this.currentlyTracking.name(), this.currentlyTracking.specialInfo(), this.currentlyTracking.description(), this.currentlyTracking.length(), this.currentlyTracking.lengthInfo(), this.currentlyTracking.difficulty(), this.currentlyTracking.requirements(), this.currentlyTracking.rewards(), currentTracker));
            WynntilsMod.info("Got location for " + this.currentlyTracking.name() + ": " + String.valueOf(currentTracker));
            this.trackManually();
        } else {
            WynntilsMod.warn("Could not get updated location for " + this.currentlyTracking.name() + ": " + String.valueOf(currentTracker));
        }
    }

    private void dumpContentBook() {
        this.currentDump = new ArrayList<DumpableActivityInfo>();
        Models.Activity.scanContentBook(ActivityType.RECOMMENDED, (activityInfos, progress) -> {
            this.currentDump.addAll(activityInfos.stream().map(DumpableActivityInfo::fromActivityInfo).toList());
            Models.Activity.scanContentBook(ActivityType.TERRITORIAL_DISCOVERY, (activityInfos2, progress2) -> {
                this.currentDump.addAll(activityInfos2.stream().map(DumpableActivityInfo::fromActivityInfo).toList());
                this.filterEntriesNeedingManualTracking();
                this.trackManually();
            });
        });
    }

    private void filterEntriesNeedingManualTracking() {
        this.manualTrackingRequired = new LinkedList<DumpableActivityInfo>();
        ArrayList<DumpableActivityInfo> trackingNeeded = new ArrayList<DumpableActivityInfo>();
        for (DumpableActivityInfo info : this.currentDump) {
            if (Objects.equals(info.name(), "Galleon's Graveyard")) continue;
            switch (info.type()) {
                case BOSS_ALTAR: 
                case LOOTRUN_CAMP: 
                case DUNGEON: 
                case RAID: {
                    trackingNeeded.add(info);
                }
            }
        }
        trackingNeeded.sort(Comparator.comparing(DumpableActivityInfo::type));
        this.manualTrackingRequired.addAll(trackingNeeded);
    }

    private void trackManually() {
        DumpableActivityInfo info = this.manualTrackingRequired.poll();
        if (info == null) {
            this.endDumping();
            return;
        }
        this.currentlyTracking = info;
        this.lastTrackedLocation = ActivityModel.ACTIVITY_MARKER_PROVIDER.getSpawnLocation().orElse(null);
        WynntilsMod.info("Tracking " + info.name());
        Models.Activity.startTracking(info.name(), info.type());
    }

    private void endDumping() {
        this.saveToDisk();
        this.currentDump = List.of();
        this.manualTrackingRequired = new LinkedList<DumpableActivityInfo>();
        this.currentlyTracking = null;
        this.lastTrackedLocation = null;
    }

    private void saveToDisk() {
        Map<ActivityType, List<DumpableActivityInfo>> mappedActivities = this.getMappedDumpedActivities();
        JsonElement element = GSON.toJsonTree(mappedActivities);
        String fileName = "content_book_dump.json";
        File jsonFile = new File(SAVE_FOLDER, fileName);
        FileUtils.mkdir(jsonFile.getParentFile());
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)element.getAsJsonObject(), (Appendable)fileWriter);
        }
        catch (IOException e) {
            WynntilsMod.error("Failed to save json file " + String.valueOf(jsonFile), e);
        }
        McUtils.sendMessageToClient((Component)Component.literal((String)("Saved content book dump to " + jsonFile.getAbsolutePath())));
    }

    private Map<ActivityType, List<DumpableActivityInfo>> getMappedDumpedActivities() {
        EnumMap<ActivityType, List<DumpableActivityInfo>> mappedDumpedActivities = new EnumMap<ActivityType, List<DumpableActivityInfo>>(ActivityType.class);
        for (ActivityType value : ActivityType.values()) {
            mappedDumpedActivities.put(value, new ArrayList());
        }
        for (DumpableActivityInfo activityInfo : this.currentDump) {
            ActivityType type = activityInfo.type();
            if (type == ActivityType.STORYLINE_QUEST) {
                type = ActivityType.QUEST;
            }
            ((List)mappedDumpedActivities.get((Object)type)).add(activityInfo);
        }
        mappedDumpedActivities.remove((Object)ActivityType.RECOMMENDED);
        mappedDumpedActivities.remove((Object)ActivityType.STORYLINE_QUEST);
        for (List value : mappedDumpedActivities.values()) {
            value.sort(Comparator.comparing(DumpableActivityInfo::name));
        }
        return mappedDumpedActivities;
    }

    private record DumpableActivityInfo(ActivityType type, String name, String specialInfo, String description, ActivityLength length, String lengthInfo, ActivityDifficulty difficulty, DumpableActivityRequirements requirements, Map<ActivityRewardType, List<String>> rewards, Location location) {
        private static DumpableActivityInfo fromActivityInfo(ActivityInfo activityInfo) {
            return new DumpableActivityInfo(activityInfo.type(), activityInfo.name(), activityInfo.specialInfo().orElse(""), activityInfo.description().map(StyledText::getString).orElse(""), activityInfo.length().orElse(null), activityInfo.lengthInfo().orElse(""), activityInfo.difficulty().orElse(null), DumpableActivityRequirements.fromActivityRequirements(activityInfo.requirements()), activityInfo.rewards().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(StyledText::getString).toList())), StyledTextUtils.extractLocation(activityInfo.description().orElse(StyledText.EMPTY)).orElse(null));
        }
    }

    private record DumpableActivityRequirements(int level, Map<ProfessionType, Integer> professionLevels, List<String> quests) {
        private static DumpableActivityRequirements fromActivityRequirements(ActivityRequirements requirements) {
            return new DumpableActivityRequirements(requirements.level().a(), requirements.professionLevels().stream().collect(Collectors.toMap(o -> (ProfessionType)((Pair)o.a()).a(), o -> (Integer)((Pair)o.a()).b())), requirements.quests().stream().map(Pair::a).toList());
        }
    }
}

