/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.activities.type.Dungeon;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.AmplifierItem;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.CrafterBagItem;
import com.wynntils.models.items.items.game.DungeonKeyItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.GatheringToolItem;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.models.items.items.game.PotionItem;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.models.items.items.game.TeleportScrollItem;
import com.wynntils.models.items.items.gui.SeaskipperDestinationItem;
import com.wynntils.models.items.items.gui.SkillPointItem;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.type.TextShadow;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ItemTextOverlayFeature
extends Feature {
    @Persisted
    private final Config<Boolean> amplifierTierEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> amplifierTierRomanNumerals = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> amplifierTierShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> aspectEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> aspectTierRomanNumerals = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> aspectShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> crafterBagEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> crafterBagShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> dungeonKeyEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> dungeonKeyShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> emeraldPouchTierEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> emeraldPouchTierRomanNumerals = new Config<Boolean>(false);
    @Persisted
    private final Config<TextShadow> emeraldPouchTierShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> gatheringToolTierEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> gatheringToolTierRomanNumerals = new Config<Boolean>(false);
    @Persisted
    private final Config<TextShadow> gatheringToolTierShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> horseTierEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> horseTierRomanNumerals = new Config<Boolean>(false);
    @Persisted
    private final Config<TextShadow> horseTierShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> hotbarTextOverlayEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> inventoryTextOverlayEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> powderTierEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> powderTierRomanNumerals = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> powderTierShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> skillIconEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> skillIconShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> teleportScrollEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> teleportScrollShadow = new Config<TextShadow>(TextShadow.OUTLINE);

    @SubscribeEvent
    public void onRenderSlot(SlotRenderEvent.Post e) {
        if (!((Boolean)this.inventoryTextOverlayEnabled.get()).booleanValue()) {
            return;
        }
        this.drawTextOverlay(e.getPoseStack(), e.getSlot().getItem(), e.getSlot().x, e.getSlot().y, false);
    }

    @SubscribeEvent
    public void onRenderHotbarSlot(HotbarSlotRenderEvent.Post e) {
        if (!((Boolean)this.hotbarTextOverlayEnabled.get()).booleanValue()) {
            return;
        }
        this.drawTextOverlay(e.getPoseStack(), e.getItemStack(), e.getX(), e.getY(), true);
    }

    private void drawTextOverlay(PoseStack poseStack, ItemStack itemStack, int slotX, int slotY, boolean hotbar) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        TextOverlayInfo overlayProperty = wynnItem.getData().getOrCalculate("overlay", () -> this.calculateOverlay(wynnItem));
        if (overlayProperty == null) {
            return;
        }
        if (!overlayProperty.isTextOverlayEnabled()) {
            return;
        }
        TextOverlay textOverlay = overlayProperty.getTextOverlay();
        if (textOverlay == null) {
            WynntilsMod.error(String.valueOf(overlayProperty) + "'s textOverlay was null.");
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 300.0f);
        poseStack.scale(textOverlay.scale(), textOverlay.scale(), 1.0f);
        float x = (float)(slotX + textOverlay.xOffset()) / textOverlay.scale();
        float y = (float)(slotY + textOverlay.yOffset()) / textOverlay.scale();
        FontRenderer.getInstance().renderText(poseStack, x, y, textOverlay.task(), Font.DisplayMode.NORMAL);
        poseStack.popPose();
    }

    private TextOverlayInfo calculateOverlay(WynnItem wynnItem) {
        PotionItem potionItem;
        if (wynnItem instanceof AmplifierItem) {
            AmplifierItem amplifierItem = (AmplifierItem)wynnItem;
            return new AmplifierOverlay(amplifierItem);
        }
        if (wynnItem instanceof AspectItem) {
            AspectItem aspectItem = (AspectItem)wynnItem;
            return new AspectOverlay(aspectItem);
        }
        if (wynnItem instanceof CrafterBagItem) {
            CrafterBagItem crafterBagItem = (CrafterBagItem)wynnItem;
            return new CrafterBagOverlay(crafterBagItem);
        }
        if (wynnItem instanceof DungeonKeyItem) {
            DungeonKeyItem dungeonKeyItem = (DungeonKeyItem)wynnItem;
            return new DungeonKeyOverlay(dungeonKeyItem);
        }
        if (wynnItem instanceof EmeraldPouchItem) {
            EmeraldPouchItem emeraldPouchItem = (EmeraldPouchItem)wynnItem;
            return new EmeraldPouchOverlay(emeraldPouchItem);
        }
        if (wynnItem instanceof GatheringToolItem) {
            GatheringToolItem gatheringToolItem = (GatheringToolItem)wynnItem;
            return new GatheringToolOverlay(gatheringToolItem);
        }
        if (wynnItem instanceof HorseItem) {
            HorseItem horseItem = (HorseItem)wynnItem;
            return new HorseOverlay(horseItem);
        }
        if (wynnItem instanceof PowderItem) {
            PowderItem powderItem = (PowderItem)wynnItem;
            return new PowderOverlay(powderItem);
        }
        if (wynnItem instanceof SeaskipperDestinationItem) {
            SeaskipperDestinationItem seaskipperDestinationItem = (SeaskipperDestinationItem)wynnItem;
            return new SeaskipperDestinationOverlay(seaskipperDestinationItem);
        }
        if (wynnItem instanceof SkillPointItem) {
            SkillPointItem skillPointItem = (SkillPointItem)wynnItem;
            return new SkillPointOverlay(skillPointItem);
        }
        if (wynnItem instanceof PotionItem && (potionItem = (PotionItem)wynnItem).getType().getSkill() != null) {
            return new SkillPotionOverlay(potionItem);
        }
        if (wynnItem instanceof TeleportScrollItem) {
            TeleportScrollItem teleportScrollItem = (TeleportScrollItem)wynnItem;
            return new TeleportScrollOverlay(teleportScrollItem);
        }
        return null;
    }

    private String valueToString(int value, boolean useRomanNumerals) {
        return useRomanNumerals ? MathUtils.toRoman(value) : String.valueOf(value);
    }

    private static interface TextOverlayInfo {
        public TextOverlay getTextOverlay();

        public boolean isTextOverlayEnabled();
    }

    private record TextOverlay(TextRenderTask task, int xOffset, int yOffset, float scale) {
    }

    private final class AmplifierOverlay
    implements TextOverlayInfo {
        private static final CustomColor HIGHLIGHT_COLOR = new CustomColor(0, 255, 255);
        private final AmplifierItem item;

        private AmplifierOverlay(AmplifierItem item) {
            this.item = item;
        }

        @Override
        public TextOverlay getTextOverlay() {
            String text = ItemTextOverlayFeature.this.valueToString(this.item.getTier(), (Boolean)ItemTextOverlayFeature.this.amplifierTierRomanNumerals.get());
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(HIGHLIGHT_COLOR).withTextShadow((TextShadow)ItemTextOverlayFeature.this.amplifierTierShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.75f);
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.amplifierTierEnabled.get();
        }
    }

    private final class AspectOverlay
    implements TextOverlayInfo {
        private static final CustomColor TIER_1_HIGHLIGHT_COLOR = CustomColor.fromChatFormatting(ChatFormatting.DARK_GRAY);
        private static final CustomColor TIER_2_HIGHLIGHT_COLOR = new CustomColor(205, 127, 50);
        private static final CustomColor TIER_3_HIGHLIGHT_COLOR = new CustomColor(192, 192, 192);
        private static final CustomColor TIER_4_HIGHLIGHT_COLOR = new CustomColor(255, 215, 0);
        private final AspectItem item;

        private AspectOverlay(AspectItem item) {
            this.item = item;
        }

        @Override
        public TextOverlay getTextOverlay() {
            CustomColor highlightColor = switch (this.item.getTier()) {
                case 2 -> TIER_2_HIGHLIGHT_COLOR;
                case 3 -> TIER_3_HIGHLIGHT_COLOR;
                case 4 -> TIER_4_HIGHLIGHT_COLOR;
                default -> TIER_1_HIGHLIGHT_COLOR;
            };
            String text = ItemTextOverlayFeature.this.valueToString(this.item.getTier(), (Boolean)ItemTextOverlayFeature.this.aspectTierRomanNumerals.get());
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(highlightColor).withTextShadow((TextShadow)ItemTextOverlayFeature.this.aspectShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.75f);
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.aspectEnabled.get();
        }
    }

    private final class CrafterBagOverlay
    implements TextOverlayInfo {
        private final CrafterBagItem item;

        private CrafterBagOverlay(CrafterBagItem item) {
            this.item = item;
        }

        @Override
        public TextOverlay getTextOverlay() {
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(this.item.getRaidKind().getRaidColor()).withTextShadow((TextShadow)ItemTextOverlayFeature.this.crafterBagShadow.get());
            return new TextOverlay(new TextRenderTask(this.item.getRaidKind().getAbbreviation(), style), -1, 1, 0.75f);
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.crafterBagEnabled.get();
        }
    }

    private final class DungeonKeyOverlay
    implements TextOverlayInfo {
        private static final CustomColor STANDARD_COLOR = CustomColor.fromChatFormatting(ChatFormatting.GOLD);
        private static final CustomColor CORRUPTED_COLOR = CustomColor.fromChatFormatting(ChatFormatting.DARK_RED);
        private static final CustomColor REMOVED_COLOR = CustomColor.fromChatFormatting(ChatFormatting.GRAY);
        private final DungeonKeyItem item;

        private DungeonKeyOverlay(DungeonKeyItem item) {
            this.item = item;
        }

        @Override
        public TextOverlay getTextOverlay() {
            Dungeon dungeon = this.item.getDungeon();
            String text = dungeon.getInitials();
            CustomColor textColor = this.item.isCorrupted() ? (dungeon.isCorruptedRemoved() ? REMOVED_COLOR : CORRUPTED_COLOR) : (dungeon.isRemoved() ? REMOVED_COLOR : STANDARD_COLOR);
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(textColor).withTextShadow((TextShadow)ItemTextOverlayFeature.this.dungeonKeyShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 1.0f);
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.dungeonKeyEnabled.get();
        }
    }

    private final class EmeraldPouchOverlay
    implements TextOverlayInfo {
        private static final CustomColor HIGHLIGHT_COLOR = CustomColor.fromChatFormatting(ChatFormatting.GREEN);
        private final EmeraldPouchItem item;

        private EmeraldPouchOverlay(EmeraldPouchItem item) {
            this.item = item;
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.emeraldPouchTierEnabled.get();
        }

        @Override
        public TextOverlay getTextOverlay() {
            String text = ItemTextOverlayFeature.this.valueToString(this.item.getTier(), (Boolean)ItemTextOverlayFeature.this.emeraldPouchTierRomanNumerals.get());
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(HIGHLIGHT_COLOR).withTextShadow((TextShadow)ItemTextOverlayFeature.this.emeraldPouchTierShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.9f);
        }
    }

    private final class GatheringToolOverlay
    implements TextOverlayInfo {
        private final GatheringToolItem item;

        private GatheringToolOverlay(GatheringToolItem item) {
            this.item = item;
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.gatheringToolTierEnabled.get();
        }

        @Override
        public TextOverlay getTextOverlay() {
            String text = ItemTextOverlayFeature.this.valueToString(this.item.getTier(), (Boolean)ItemTextOverlayFeature.this.gatheringToolTierRomanNumerals.get());
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(CustomColor.fromChatFormatting(ChatFormatting.DARK_AQUA)).withTextShadow((TextShadow)ItemTextOverlayFeature.this.gatheringToolTierShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.9f);
        }
    }

    private final class HorseOverlay
    implements TextOverlayInfo {
        private final HorseItem item;

        private HorseOverlay(HorseItem item) {
            this.item = item;
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.horseTierEnabled.get();
        }

        @Override
        public TextOverlay getTextOverlay() {
            String text = ItemTextOverlayFeature.this.valueToString(this.item.getTier().getNumeral(), (Boolean)ItemTextOverlayFeature.this.horseTierRomanNumerals.get());
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(CustomColor.fromChatFormatting(ChatFormatting.DARK_AQUA)).withTextShadow((TextShadow)ItemTextOverlayFeature.this.horseTierShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.9f);
        }
    }

    private final class PowderOverlay
    implements TextOverlayInfo {
        private final PowderItem item;

        private PowderOverlay(PowderItem item) {
            this.item = item;
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.powderTierEnabled.get();
        }

        @Override
        public TextOverlay getTextOverlay() {
            CustomColor highlightColor = this.item.getPowderProfile().element().getColor();
            String text = ItemTextOverlayFeature.this.valueToString(this.item.getTier(), (Boolean)ItemTextOverlayFeature.this.powderTierRomanNumerals.get());
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(highlightColor).withTextShadow((TextShadow)ItemTextOverlayFeature.this.powderTierShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.75f);
        }
    }

    private final class SeaskipperDestinationOverlay
    implements TextOverlayInfo {
        private static final CustomColor CITY_COLOR = CustomColor.fromChatFormatting(ChatFormatting.AQUA);
        private final SeaskipperDestinationItem item;

        private SeaskipperDestinationOverlay(SeaskipperDestinationItem item) {
            this.item = item;
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.teleportScrollEnabled.get();
        }

        @Override
        public TextOverlay getTextOverlay() {
            String text = this.item.getShorthand();
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(CITY_COLOR).withTextShadow((TextShadow)ItemTextOverlayFeature.this.teleportScrollShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), 0, 0, 1.0f);
        }
    }

    private final class SkillPointOverlay
    implements TextOverlayInfo {
        private final SkillPointItem item;

        private SkillPointOverlay(SkillPointItem item) {
            this.item = item;
        }

        @Override
        public TextOverlay getTextOverlay() {
            Skill skill = this.item.getSkill();
            StyledText text = StyledText.fromComponent((Component)Component.literal((String)skill.getSymbol()).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common"))));
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(CustomColor.fromChatFormatting(skill.getColorCode())).withTextShadow((TextShadow)ItemTextOverlayFeature.this.skillIconShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.9f);
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.skillIconEnabled.get();
        }
    }

    private final class SkillPotionOverlay
    implements TextOverlayInfo {
        private final PotionItem item;

        private SkillPotionOverlay(PotionItem item) {
            this.item = item;
        }

        @Override
        public TextOverlay getTextOverlay() {
            Skill skill = this.item.getType().getSkill();
            StyledText text = StyledText.fromComponent((Component)Component.literal((String)skill.getSymbol()).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common"))));
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(CustomColor.fromChatFormatting(skill.getColorCode())).withTextShadow((TextShadow)ItemTextOverlayFeature.this.skillIconShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), -1, 1, 0.9f);
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.skillIconEnabled.get();
        }
    }

    private final class TeleportScrollOverlay
    implements TextOverlayInfo {
        private static final CustomColor CITY_COLOR = CustomColor.fromChatFormatting(ChatFormatting.AQUA);
        private static final CustomColor DUNGEON_COLOR = CustomColor.fromChatFormatting(ChatFormatting.GOLD);
        private static final CustomColor OUT_OF_CHARGES_COLOR = CustomColor.fromChatFormatting(ChatFormatting.RED);
        private final TeleportScrollItem item;

        private TeleportScrollOverlay(TeleportScrollItem item) {
            this.item = item;
        }

        @Override
        public boolean isTextOverlayEnabled() {
            return (Boolean)ItemTextOverlayFeature.this.teleportScrollEnabled.get();
        }

        @Override
        public TextOverlay getTextOverlay() {
            CustomColor textColor = this.item.getRemainingCharges() <= 0 ? OUT_OF_CHARGES_COLOR : (this.item.isDungeon() ? DUNGEON_COLOR : CITY_COLOR);
            String text = this.item.getDestination();
            TextRenderSetting style = TextRenderSetting.DEFAULT.withCustomColor(textColor).withTextShadow((TextShadow)ItemTextOverlayFeature.this.teleportScrollShadow.get());
            return new TextOverlay(new TextRenderTask(text, style), 0, 0, 1.0f);
        }
    }
}

