/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.players;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.features.tooltips.ItemStatInfoFeature;
import com.wynntils.mc.event.EntityNameTagRenderEvent;
import com.wynntils.mc.event.GetCameraEntityEvent;
import com.wynntils.mc.event.PlayerNametagRenderEvent;
import com.wynntils.mc.event.RenderLevelEvent;
import com.wynntils.mc.extension.EntityRenderStateExtension;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.players.WynntilsUser;
import com.wynntils.models.players.type.AccountType;
import com.wynntils.screens.playerviewer.PlayerViewerScreen;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.leaderboard.type.LeaderboardBadge;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.wynn.ColorScaleUtils;
import com.wynntils.utils.wynn.RaycastUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.PLAYERS)
public class CustomNametagRendererFeature
extends Feature {
    private static final float ACCOUNT_TYPE_MULTIPLIER = 1.5f;
    private static final float NAMETAG_HEIGHT = 0.25875f;
    private static final float BADGE_MARGIN = 2.0f;
    private static final int BADGE_SCROLL_SPEED = 40;
    private static final ResourceLocation WYNNTILS_NAMETAG_LOGO_FONT = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"nametag");
    private static final String WYNNTILS_NAMETAG_LOGO = "\ue100";
    @Persisted
    private final Config<Boolean> hideAllNametags = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> showOwnNametag = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> hidePlayerNametags = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> hideNametagBackground = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> showLeaderboardBadges = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> badgeCount = new Config<Integer>(7);
    @Persisted
    private final Config<Boolean> showGearOnHover = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showGearPercentage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showWynntilsMarker = new Config<Boolean>(true);
    @Persisted
    private final Config<Float> customNametagScale = new Config<Float>(Float.valueOf(0.5f));
    private Player hitPlayerCache = null;

    @SubscribeEvent
    public void onPlayerNameTagRender(PlayerNametagRenderEvent event) {
        PlayerViewerScreen playerViewerScreen;
        Entity entity = ((EntityRenderStateExtension)event.getEntityRenderState()).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        if (Models.Player.isNpc((Player)player)) {
            return;
        }
        if (((Boolean)this.hidePlayerNametags.get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        Screen screen = McUtils.mc().screen;
        if (screen instanceof PlayerViewerScreen && (playerViewerScreen = (PlayerViewerScreen)screen).getPlayer() == player) {
            return;
        }
        ArrayList<CustomNametag> nametags = new ArrayList<CustomNametag>();
        if (((Boolean)this.showGearOnHover.get()).booleanValue()) {
            this.addGearNametags(event, nametags);
        }
        this.addAccountTypeNametag(event, nametags);
        if (!nametags.isEmpty()) {
            event.setCanceled(true);
            this.drawNametags(event, nametags);
        } else {
            this.drawBadges(event, 0.0f);
        }
    }

    @SubscribeEvent
    public void onEntityNameTagRender(EntityNameTagRenderEvent event) {
        if (((Boolean)this.hideAllNametags.get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        if (((Boolean)this.hideNametagBackground.get()).booleanValue()) {
            event.setBackgroundOpacity(0.0f);
        }
    }

    @SubscribeEvent
    public void onCameraCheck(GetCameraEntityEvent e) {
        if (!((Boolean)this.showOwnNametag.get()).booleanValue()) {
            return;
        }
        if (McUtils.mc().screen != null && !(McUtils.mc().screen instanceof ChatScreen)) {
            return;
        }
        e.setEntity(null);
    }

    @SubscribeEvent
    public void onRenderLevel(RenderLevelEvent.Pre event) {
        Optional<Player> hitPlayer = RaycastUtils.getHoveredPlayer();
        this.hitPlayerCache = hitPlayer.orElse(null);
    }

    private void addGearNametags(PlayerNametagRenderEvent event, List<CustomNametag> nametags) {
        Entity entity = ((EntityRenderStateExtension)event.getEntityRenderState()).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        LocalPlayer localPlayer = McUtils.player();
        if (this.hitPlayerCache != player) {
            return;
        }
        if (!Models.Player.isLocalPlayer((Player)localPlayer)) {
            return;
        }
        Optional<HadesUser> hadesUserOpt = Services.Hades.getHadesUser(this.hitPlayerCache.getUUID());
        if (hadesUserOpt.isEmpty()) {
            return;
        }
        MutableComponent handComp = CustomNametagRendererFeature.getItemComponent(hadesUserOpt.get().getHeldItem(), (Boolean)this.showGearPercentage.get());
        if (handComp != null) {
            nametags.add(new CustomNametag((Component)handComp, ((Float)this.customNametagScale.get()).floatValue()));
        }
        for (InventoryAccessory accessory : hadesUserOpt.get().getAccessories().descendingKeySet()) {
            MutableComponent accessoryComp = CustomNametagRendererFeature.getItemComponent((WynnItem)hadesUserOpt.get().getAccessories().get((Object)accessory), (Boolean)this.showGearPercentage.get());
            if (accessoryComp == null) continue;
            nametags.add(new CustomNametag((Component)accessoryComp, ((Float)this.customNametagScale.get()).floatValue()));
        }
        for (InventoryArmor armor : hadesUserOpt.get().getArmor().descendingKeySet()) {
            MutableComponent armorComp = CustomNametagRendererFeature.getItemComponent((WynnItem)hadesUserOpt.get().getArmor().get((Object)armor), (Boolean)this.showGearPercentage.get());
            if (armorComp == null) continue;
            nametags.add(new CustomNametag((Component)armorComp, ((Float)this.customNametagScale.get()).floatValue()));
        }
    }

    private static MutableComponent getItemComponent(WynnItem wynnItem, boolean showGearPercentage) {
        if (wynnItem == null) {
            return null;
        }
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            String itemName = gearItem.getItemInfo().name();
            MutableComponent gearComponent = Component.literal((String)itemName).withStyle(gearItem.getItemInfo().tier().getChatFormatting());
            if (gearItem.getShinyStat().isPresent()) {
                gearComponent = Component.literal((String)"\u2b21 ").append((Component)Component.literal((String)"Shiny ").withStyle(gearItem.getItemInfo().tier().getChatFormatting())).append((Component)gearComponent);
            }
            if (showGearPercentage && gearItem.hasOverallValue()) {
                ItemStatInfoFeature isif = Managers.Feature.getFeatureInstance(ItemStatInfoFeature.class);
                gearComponent.append((Component)ColorScaleUtils.getPercentageTextComponent(isif.getColorMap(), gearItem.getOverallPercentage(), (Boolean)isif.colorLerp.get(), (Integer)isif.decimalPlaces.get()));
            }
            return gearComponent;
        }
        if (wynnItem instanceof CraftedGearItem) {
            CraftedGearItem craftedGearItem = (CraftedGearItem)wynnItem;
            return Component.literal((String)craftedGearItem.getName()).withStyle(craftedGearItem.getGearTier().getChatFormatting());
        }
        return null;
    }

    private void addAccountTypeNametag(PlayerNametagRenderEvent event, List<CustomNametag> nametags) {
        Entity entity = ((EntityRenderStateExtension)event.getEntityRenderState()).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        WynntilsUser user = Models.Player.getWynntilsUser((Player)player);
        if (user == null) {
            if (!nametags.isEmpty()) {
                Component realName = event.getDisplayName();
                nametags.add(new CustomNametag(realName, 1.0f));
            }
            return;
        }
        AccountType accountType = user.accountType();
        if (accountType.getComponent() != null) {
            nametags.add(new CustomNametag((Component)accountType.getComponent(), ((Float)this.customNametagScale.get()).floatValue() * 1.5f));
        }
        if (!((Boolean)this.showWynntilsMarker.get()).booleanValue()) {
            Component realName = event.getDisplayName();
            nametags.add(new CustomNametag(realName, 1.0f));
            return;
        }
        ChatFormatting logoColor = Models.Player.isLocalPlayer((Player)player) ? ChatFormatting.WHITE : ChatFormatting.GRAY;
        MutableComponent prefixedName = Component.empty().append((Component)Component.literal((String)WYNNTILS_NAMETAG_LOGO).withStyle(Style.EMPTY.withFont(WYNNTILS_NAMETAG_LOGO_FONT).withColor(logoColor))).append(" ").append(event.getDisplayName());
        nametags.add(new CustomNametag((Component)prefixedName, 1.0f));
    }

    private void drawNametags(PlayerNametagRenderEvent event, List<CustomNametag> nametags) {
        Entity entity = ((EntityRenderStateExtension)event.getEntityRenderState()).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        int backgroundColor = (Boolean)this.hideNametagBackground.get() != false ? 0 : (int)(McUtils.options().getBackgroundOpacity(0.25f) * 255.0f) << 24;
        float yOffset = 0.0f;
        for (CustomNametag nametag : nametags) {
            RenderUtils.renderCustomNametag(event.getPoseStack(), event.getBuffer(), event.getPackedLight(), backgroundColor, event.getEntityRenderDispatcher(), (Entity)player, nametag.nametagComponent(), event.getFont(), nametag.nametagScale(), yOffset += nametag.nametagScale() * 0.25875f);
        }
        this.drawBadges(event, yOffset);
    }

    private void drawBadges(PlayerNametagRenderEvent event, float height) {
        if (!((Boolean)this.showLeaderboardBadges.get()).booleanValue()) {
            return;
        }
        if ((Integer)this.badgeCount.get() <= 0) {
            return;
        }
        Entity entity = ((EntityRenderStateExtension)event.getEntityRenderState()).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        List<LeaderboardBadge> allBadges = Services.Leaderboard.getBadges(Models.Player.getUserUUID((Player)player));
        if (allBadges.isEmpty()) {
            return;
        }
        List<Object> badgesToRender = new ArrayList();
        if ((Integer)this.badgeCount.get() >= allBadges.size()) {
            badgesToRender = allBadges;
        } else {
            int offset = McUtils.player().tickCount / 40 % allBadges.size();
            for (int i = 0; i < (Integer)this.badgeCount.get(); ++i) {
                badgesToRender.add(allBadges.get((i + offset) % allBadges.size()));
            }
        }
        float totalWidth = (float)(19 * badgesToRender.size()) + 2.0f * (float)(badgesToRender.size() - 1);
        float xOffset = -(totalWidth / 2.0f) + 9.5f;
        float yOffset = 15.0f;
        if (height == 0.0f) {
            yOffset += 10.0f;
        }
        for (LeaderboardBadge leaderboardBadge : badgesToRender) {
            RenderUtils.renderProfessionBadge(event.getPoseStack(), event.getEntityRenderDispatcher(), (Entity)player, Texture.LEADERBOARD_BADGES.resource(), 19.0f, 18.0f, leaderboardBadge.uOffset(), leaderboardBadge.vOffset(), 19, 18, Texture.LEADERBOARD_BADGES.width(), Texture.LEADERBOARD_BADGES.height(), height, xOffset, yOffset);
            xOffset += 21.0f;
        }
    }

    private record CustomNametag(Component nametagComponent, float nametagScale) {
    }
}

