/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.screens.bulkbuy.widgets.BulkBuyWidget;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.type.IterationDecision;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class BulkBuyFeature
extends Feature {
    @Persisted
    private final Config<Integer> bulkBuyAmount = new Config<Integer>(4);
    @Persisted
    private final Config<BulkBuySpeed> bulkBuySpeed = new Config<BulkBuySpeed>(BulkBuySpeed.BALANCED);
    @Persisted
    private final Config<Integer> animationDuration = new Config<Integer>(125);
    private static final String SHOP_TITLE_SUFFIX = " Shop";
    private static final Pattern PRICE_PATTERN = Pattern.compile("\u00a76\udaff\udffc\uf001\udb00\udc06 \u00a7(?:c\u2716|a\u2714)(?:\u00a76)? \u00a7f(\\d{1,3}(?:,\\d{3})*)\u00b2 \u00a78(.+)");
    private static final ChatFormatting BULK_BUY_ACTIVE_COLOR = ChatFormatting.GREEN;
    private static final StyledText PRICE_STR = StyledText.fromString("\u00a76\udaff\udffc\ue00a\udaff\udfff\ue002\udaff\udffe Price");
    private BulkBuyWidget bulkBuyWidget;
    private int bulkBoughtSlotNumber = -1;
    private AbstractContainerMenu bulkBoughtContainer = null;
    private ItemStack bulkBoughtItemStack = null;
    private int bulkBoughtAmount = 0;
    private int bulkBoughtPrice = 0;

    @SubscribeEvent
    public void onShopOpened(SetSlotEvent.Post e) {
        if (e.getSlot() != 4 || e.getContainer().getContainerSize() != 54) {
            return;
        }
        this.initBulkBuyWidget(McUtils.mc().screen);
    }

    @SubscribeEvent
    public void onContainerOpened(ScreenInitEvent.Post e) {
        this.initBulkBuyWidget(e.getScreen());
    }

    private void initBulkBuyWidget(Screen screen) {
        if (this.bulkBoughtSlotNumber != -1) {
            return;
        }
        if (!(screen instanceof ContainerScreen)) {
            return;
        }
        ContainerScreen containerScreen = (ContainerScreen)screen;
        AbstractContainerMenu abstractContainerMenu = containerScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractContainerMenu)) {
            return;
        }
        AbstractContainerMenu acm = abstractContainerMenu;
        if (acm.getItems().size() != 90) {
            return;
        }
        StyledText title = StyledText.fromComponent(acm.getSlot(4).getItem().getHoverName());
        if (!title.startsWith(ChatFormatting.GREEN.toString()) || !title.endsWith(SHOP_TITLE_SUFFIX)) {
            return;
        }
        this.bulkBuyWidget = new BulkBuyWidget(containerScreen.leftPos, containerScreen.topPos - 5, Texture.BULK_BUY_PANEL.width(), Texture.BULK_BUY_PANEL.height(), (Integer)this.animationDuration.get());
        containerScreen.addRenderableOnly((Renderable)this.bulkBuyWidget);
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        ItemStack itemStack;
        if (!KeyboardUtils.isShiftDown() || e.getClickType() != ClickType.QUICK_MOVE) {
            return;
        }
        AbstractContainerMenu container = e.getContainerMenu();
        if (!this.isBulkBuyable(container, itemStack = e.getItemStack())) {
            return;
        }
        int itemPrice = this.findItemPrice(LoreUtils.getLore(itemStack));
        if (itemPrice * (this.bulkBoughtAmount + (Integer)this.bulkBuyAmount.get()) > Models.Emerald.getAmountInInventory()) {
            McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.bulkBuy.bulkBuyCannotAfford", (Object[])new Object[0]));
            return;
        }
        if (this.bulkBoughtSlotNumber == -1) {
            this.bulkBoughtSlotNumber = e.getSlotNum();
            this.bulkBoughtContainer = container;
            this.bulkBoughtItemStack = itemStack;
            this.bulkBoughtAmount = (Integer)this.bulkBuyAmount.get();
            this.bulkBoughtPrice = itemPrice;
        } else {
            if (this.bulkBoughtSlotNumber != e.getSlotNum()) {
                McUtils.sendErrorToClient(I18n.get((String)"feature.wynntils.bulkBuy.bulkBuyDifferentItem", (Object[])new Object[0]));
                return;
            }
            this.bulkBoughtAmount += ((Integer)this.bulkBuyAmount.get()).intValue();
        }
        this.bulkBuyWidget.setBulkBoughtItem(new BulkBoughtItem(this.bulkBoughtItemStack, this.bulkBoughtAmount, this.bulkBoughtPrice));
        e.setCanceled(true);
    }

    @SubscribeEvent
    public void onShopClosed(ContainerCloseEvent.Pre e) {
        this.resetBulkBuy(false);
        this.bulkBuyWidget = null;
    }

    @SubscribeEvent
    public void onTickPurchase(TickEvent e) {
        if (this.bulkBoughtSlotNumber == -1) {
            return;
        }
        if (McUtils.mc().level.getGameTime() % (long)((BulkBuySpeed)((Object)this.bulkBuySpeed.get())).getTicksDelay() != 0L) {
            return;
        }
        ContainerUtils.clickOnSlot(this.bulkBoughtSlotNumber, this.bulkBoughtContainer.containerId, 1, (List<ItemStack>)this.bulkBoughtContainer.getItems());
        --this.bulkBoughtAmount;
        if (this.bulkBoughtAmount <= 0) {
            this.resetBulkBuy(true);
        } else {
            this.bulkBuyWidget.setBulkBoughtItem(new BulkBoughtItem(this.bulkBoughtItemStack, this.bulkBoughtAmount, this.bulkBoughtPrice));
        }
    }

    private void resetBulkBuy(boolean resetWidget) {
        this.bulkBoughtSlotNumber = -1;
        this.bulkBoughtContainer = null;
        this.bulkBoughtAmount = 0;
        this.bulkBoughtPrice = 0;
        if (!resetWidget) {
            return;
        }
        this.bulkBuyWidget.setBulkBoughtItem(null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onTooltipPre(ItemTooltipRenderEvent.Pre event) {
        if (!this.isBulkBuyable(McUtils.containerMenu(), event.getItemStack())) {
            return;
        }
        MutableComponent component = Component.empty().append((Component)Component.literal((String)"\ue004\udb00\udc02\ue014\udb00\udc02\ue000").withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"keybind")))).append((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"feature.wynntils.bulkBuy.bulkBuyActive", (Object[])new Object[]{this.bulkBuyAmount.get()})).withStyle(BULK_BUY_ACTIVE_COLOR));
        List<MutableComponent> tooltips = List.of(component);
        event.setTooltips(LoreUtils.appendTooltip(event.getItemStack(), this.replacePrices(event.getItemStack(), event.getTooltips()), tooltips));
    }

    private int findItemPrice(List<StyledText> lore) {
        for (StyledText styledTextParts : lore) {
            Matcher priceMatcher = styledTextParts.getMatcher(PRICE_PATTERN);
            if (!priceMatcher.find()) continue;
            return Integer.parseInt(priceMatcher.group(1).replaceAll(",", ""));
        }
        WynntilsMod.warn("Bulk Buy could not find price for " + lore.getFirst().getString());
        return -1;
    }

    private List<Component> replacePrices(ItemStack itemStack, List<Component> oldLore) {
        if (!KeyboardUtils.isShiftDown()) {
            return oldLore;
        }
        ArrayList<Component> returnable = new ArrayList<Component>(oldLore);
        returnable.set(0, (Component)Component.literal((String)(String.valueOf(this.bulkBuyAmount.get()) + "x ")).append(itemStack.getHoverName()));
        for (Component line : oldLore) {
            StyledText oldLine = StyledText.fromComponent(line);
            Matcher priceMatcher = oldLine.getMatcher(PRICE_PATTERN);
            if (!priceMatcher.find()) continue;
            int newPrice = Integer.parseInt(priceMatcher.group(1).replaceAll(",", "")) * (Integer)this.bulkBuyAmount.get();
            StyledText newLine = oldLine.iterateBackwards((part, changes) -> {
                StyledTextPart newPart;
                if (newPrice > Models.Emerald.getAmountInInventory() && part.getString(null, StyleType.NONE).equals("\u2714")) {
                    changes.remove(part);
                    newPart = new StyledTextPart("\u2716", part.getPartStyle().getStyle().withColor(ChatFormatting.RED), null, Style.EMPTY);
                    changes.add(newPart);
                }
                if (part.getString(null, StyleType.NONE).startsWith(priceMatcher.group(1))) {
                    changes.remove(part);
                    newPart = new StyledTextPart(Models.Emerald.getEmeraldCountString(newPrice, true) + " ", part.getPartStyle().getStyle(), null, Style.EMPTY);
                    changes.add(newPart);
                    return IterationDecision.CONTINUE;
                }
                if (part.getString(null, StyleType.NONE).equals(priceMatcher.group(2))) {
                    changes.remove(part);
                    newPart = new StyledTextPart("(" + Models.Emerald.getFormattedString(newPrice, false) + ")", part.getPartStyle().getStyle(), null, Style.EMPTY);
                    changes.add(newPart);
                    return IterationDecision.CONTINUE;
                }
                return IterationDecision.CONTINUE;
            });
            returnable.set(returnable.indexOf(line), (Component)newLine.getComponent());
            break;
        }
        if (returnable == oldLore) {
            WynntilsMod.warn("Could not find price for " + oldLore.getFirst().getString());
        }
        return returnable;
    }

    private boolean isBulkBuyable(AbstractContainerMenu menu, ItemStack toBuy) {
        StyledText title = StyledText.fromComponent(menu.getSlot(4).getItem().getHoverName());
        return title.startsWith(ChatFormatting.GREEN.toString()) && title.endsWith(SHOP_TITLE_SUFFIX) && LoreUtils.getStringLore(toBuy).contains(PRICE_STR);
    }

    public static enum BulkBuySpeed {
        FAST(4),
        BALANCED(5),
        SAFE(6),
        VERY_SAFE(8);

        private final int ticksDelay;

        private BulkBuySpeed(int ticksDelay) {
            this.ticksDelay = ticksDelay;
        }

        private int getTicksDelay() {
            return this.ticksDelay;
        }
    }

    public record BulkBoughtItem(ItemStack itemStack, int amount, int price) {
    }
}

