/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PlayerInfoEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.WYNNTILS)
public class BetaWarningFeature
extends Feature {
    private WarnType warnType = WarnType.NONE;

    @SubscribeEvent
    public void onConnect(WynncraftConnectionEvent.Connected event) {
        if (WynntilsMod.isDevelopmentBuild()) {
            return;
        }
        this.warnType = event.getHost().equals("beta") && !WynntilsMod.isBeta() ? WarnType.RELEASE : (!event.getHost().equals("beta") && WynntilsMod.isBeta() ? WarnType.BETA : WarnType.NONE);
    }

    @SubscribeEvent
    public void onDisplayNameChange(PlayerInfoEvent.PlayerDisplayNameChangeEvent e) {
        if (this.warnType == WarnType.NONE) {
            return;
        }
        McUtils.sendMessageToClient(this.warnType.getWarning());
        this.warnType = WarnType.NONE;
    }

    private static enum WarnType {
        NONE(Component::empty),
        BETA(() -> Component.translatable((String)"feature.wynntils.betaWarning.usingBetaOnNormalServer")),
        RELEASE(() -> Component.translatable((String)"feature.wynntils.betaWarning.usingReleaseOnBetaServer", (Object[])new Object[]{Managers.Url.getUrl(UrlId.LINK_WYNNTILS_DISCORD_INVITE)}));

        private final Supplier<Component> warningSupplier;

        private WarnType(Supplier<Component> warningSupplier) {
            this.warningSupplier = warningSupplier;
        }

        public Component getWarning() {
            return this.warningSupplier.get();
        }
    }
}

