/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombSortOrder;
import com.wynntils.utils.type.Time;
import java.util.List;
import net.minecraft.client.resources.language.I18n;

public class BombFunctions {

    public static class BombRemainingTimeFunction
    extends BombFunctionBase<Time> {
        @Override
        public Time processInfo(BombInfo info) {
            return Time.of(info.getRemainingLong());
        }

        @Override
        public Time invalidValue() {
            return Time.NONE;
        }
    }

    public static class BombOwnerFunction
    extends BombFunctionBase<String> {
        @Override
        public String processInfo(BombInfo info) {
            return info.user();
        }

        @Override
        public String invalidValue() {
            return "";
        }
    }

    public static class BombEndTimeFunction
    extends BombFunctionBase<Time> {
        @Override
        public Time processInfo(BombInfo info) {
            return Time.of(info.endTime());
        }

        @Override
        public Time invalidValue() {
            return Time.NONE;
        }
    }

    public static class BombLengthFunction
    extends BombFunctionBase<Float> {
        @Override
        public Float processInfo(BombInfo info) {
            return Float.valueOf(info.length());
        }

        @Override
        public Float invalidValue() {
            return Float.valueOf(-1.0f);
        }
    }

    public static class BombStartTimeFunction
    extends BombFunctionBase<Time> {
        @Override
        public Time processInfo(BombInfo info) {
            return Time.of(info.startTime());
        }

        @Override
        public Time invalidValue() {
            return Time.NONE;
        }
    }

    public static class BombWorldFunction
    extends BombFunctionBase<String> {
        @Override
        public String processInfo(BombInfo info) {
            return info.server();
        }

        @Override
        public String invalidValue() {
            return "";
        }
    }

    public static class BombTypeFunction
    extends BombFunctionBase<String> {
        @Override
        public String processInfo(BombInfo info) {
            return info.bomb().getDisplayName();
        }

        @Override
        public String invalidValue() {
            return "";
        }
    }

    public static class BombFormattedStringFunction
    extends BombFunctionBase<String> {
        @Override
        public String processInfo(BombInfo info) {
            return info.asString();
        }

        @Override
        public String invalidValue() {
            return "";
        }
    }

    private static abstract class BombFunctionBase<T>
    extends Function<T> {
        private BombFunctionBase() {
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("index", Integer.class, null), new Argument<Object>("group", Boolean.class, null), new Argument<Object>("sortOrder", String.class, null)));
        }

        @Override
        public T getValue(FunctionArguments arguments) {
            BombSortOrder sortOrder;
            int index = arguments.getArgument("index").getIntegerValue();
            boolean group = arguments.getArgument("group").getBooleanValue();
            List<BombInfo> bombInfo = Models.Bomb.getBombBellStream(group, sortOrder = BombSortOrder.fromString(arguments.getArgument("sortOrder").getStringValue())).toList();
            return !bombInfo.isEmpty() && index >= 0 && index < bombInfo.size() ? this.processInfo(bombInfo.get(index)) : this.invalidValue();
        }

        @Override
        public String getArgumentDescription(String argumentName) {
            return I18n.get((String)("function.wynntils.bombFunctionBase.argument." + argumentName), (Object[])new Object[0]);
        }

        public abstract T processInfo(BombInfo var1);

        public abstract T invalidValue();
    }
}

