/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.chat.event;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.handlers.chat.type.RecipientType;
import net.neoforged.bus.api.Event;

public abstract class ChatMessageEvent
extends Event {
    protected final StyledText message;
    private final MessageType messageType;
    private final RecipientType recipientType;

    protected ChatMessageEvent(StyledText message, MessageType messageType, RecipientType recipientType) {
        this.message = message;
        this.messageType = messageType;
        this.recipientType = recipientType;
    }

    public StyledText getMessage() {
        return this.message;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public RecipientType getRecipientType() {
        return this.recipientType;
    }

    public static class Edit
    extends ChatMessageEvent {
        private StyledText editedMessage = null;

        public Edit(StyledText message, MessageType messageType, RecipientType recipientType) {
            super(message, messageType, recipientType);
        }

        @Override
        public StyledText getMessage() {
            return this.editedMessage != null ? this.editedMessage : this.message;
        }

        public void setMessage(StyledText message) {
            this.editedMessage = message;
        }
    }

    public static class Match
    extends ChatMessageEvent {
        private boolean chatCanceled = false;

        public Match(StyledText message, MessageType messageType, RecipientType recipientType) {
            super(message, messageType, recipientType);
        }

        public boolean isChatCanceled() {
            return this.chatCanceled;
        }

        public void cancelChat() {
            this.chatCanceled = true;
        }
    }
}

