/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.crafted;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatListDelimiter;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class CraftedTooltipIdentifications {
    public static List<Component> buildTooltip(CraftedItemProperty craftedItem, ClassType currentClass, TooltipStyle style) {
        ArrayList<Component> identifications = new ArrayList<Component>();
        List<StatType> listOrdering = Models.Stat.getOrderingList(style.identificationOrdering());
        ArrayList<StatType> allStats = new ArrayList<StatType>(craftedItem.getStatTypes());
        if (allStats.isEmpty()) {
            return identifications;
        }
        boolean useDelimiters = style.useDelimiters();
        boolean delimiterNeeded = false;
        for (StatType statType : listOrdering) {
            MutableComponent line;
            if (useDelimiters && statType instanceof StatListDelimiter && delimiterNeeded) {
                identifications.add((Component)Component.literal((String)""));
                delimiterNeeded = false;
            }
            if (!allStats.contains(statType) || (line = CraftedTooltipIdentifications.getStatLine(statType, craftedItem, currentClass, style)) == null) continue;
            identifications.add((Component)line);
            delimiterNeeded = true;
        }
        if (!identifications.isEmpty() && ((Component)identifications.getLast()).getString().isEmpty()) {
            identifications.removeLast();
        }
        return identifications;
    }

    private static MutableComponent getStatLine(StatType statType, CraftedItemProperty craftedItem, ClassType currentClass, TooltipStyle style) {
        StatActualValue statActualValue = craftedItem.getIdentifications().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
        if (statActualValue == null) {
            WynntilsMod.warn("Missing value in item " + craftedItem.getName() + " for stat: " + String.valueOf(statType));
            return null;
        }
        MutableComponent line = CraftedTooltipIdentifications.buildIdentifiedLine(craftedItem, style, statActualValue, currentClass);
        return line;
    }

    private static MutableComponent buildIdentifiedLine(CraftedItemProperty craftedItem, TooltipStyle style, StatActualValue actualValue, ClassType currentClass) {
        StatType statType = actualValue.statType();
        int value = actualValue.value();
        int valueToShow = statType.calculateAsInverted() ? -value : value;
        boolean hasPositiveEffect = valueToShow > 0 ^ statType.displayAsInverted();
        MutableComponent line = Component.literal((String)(StringUtils.toSignedString(valueToShow) + statType.getUnit().getDisplayName())).withStyle(Style.EMPTY.withColor(hasPositiveEffect ? ChatFormatting.GREEN : ChatFormatting.RED));
        if (style.showMaxValue() && !(craftedItem instanceof CraftedConsumableItem)) {
            craftedItem.getPossibleValues().stream().filter(possibleValues -> possibleValues.statType() == statType).findFirst().ifPresent(possibleValues -> line.append((Component)Component.literal((String)("/" + StringUtils.toSignedString(possibleValues.range().high()) + statType.getUnit().getDisplayName())).withStyle(ChatFormatting.DARK_GRAY)));
        }
        line.append((Component)Component.literal((String)(" " + Models.Stat.getDisplayName(statType, craftedItem.getRequiredClass(), currentClass, RangedValue.NONE))).withStyle(ChatFormatting.GRAY));
        return line;
    }
}

