/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.crafted.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipComponent;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class CraftedConsumableTooltipComponent
extends CraftedTooltipComponent<CraftedConsumableItem> {
    @Override
    public List<Component> buildHeaderTooltip(CraftedConsumableItem craftedItem) {
        int level;
        ArrayList<Component> header = new ArrayList<Component>();
        header.add((Component)Component.literal((String)craftedItem.getName()).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)(" [" + craftedItem.getUses().current() + "/" + craftedItem.getUses().max() + "]")).withStyle(ChatFormatting.AQUA)));
        if (!craftedItem.getNamedEffects().isEmpty()) {
            header.add((Component)Component.literal((String)"Effect:").withStyle(ChatFormatting.GREEN));
            craftedItem.getNamedEffects().forEach(effect -> header.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)(StringUtils.capitalizeFirst(effect.type().name().toLowerCase(Locale.ROOT)) + ": ")).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(effect.value())).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(" " + effect.type().getSuffix()))))));
            header.add((Component)Component.literal((String)""));
        }
        if ((level = craftedItem.getLevel()) != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= level;
            header.add((Component)this.buildRequirementLine("Combat Lv. Min: " + level, fulfilled));
            header.add((Component)Component.literal((String)""));
        }
        return header;
    }

    @Override
    public List<Component> buildFooterTooltip(CraftedConsumableItem craftedItem) {
        ArrayList<Component> footer = new ArrayList<Component>();
        footer.add((Component)Component.empty());
        footer.add((Component)Component.literal((String)"Crafted ").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)StringUtils.capitalizeFirst(craftedItem.getConsumableType().name().toLowerCase(Locale.ROOT)))));
        return footer;
    }
}

