/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable.components;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.gear.type.GearMajorId;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public final class GearTooltipComponent
extends IdentifiableTooltipComponent<GearInfo, GearInstance> {
    private static final int PIXEL_WIDTH = 150;

    @Override
    public List<Component> buildHeaderTooltip(GearInfo gearInfo, GearInstance gearInstance, boolean hideUnidentified) {
        int n;
        int health;
        ArrayList<Component> header = new ArrayList<Component>();
        String unidentifiedPrefix = gearInstance == null && !hideUnidentified ? "Unidentified " : "";
        MutableComponent shinyPrefix = gearInstance != null && gearInstance.shinyStat().isPresent() ? Component.literal((String)"\u2b21 ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"Shiny ").withStyle(gearInfo.tier().getChatFormatting())) : Component.empty();
        header.add((Component)Component.empty().withStyle(gearInfo.tier().getChatFormatting()).append((Component)Component.literal((String)unidentifiedPrefix).append((Component)shinyPrefix).append((Component)Component.literal((String)gearInfo.name()))));
        if (gearInfo.fixedStats().attackSpeed().isPresent()) {
            header.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + gearInfo.fixedStats().attackSpeed().get().getName())));
        }
        header.add((Component)Component.literal((String)""));
        if (!gearInfo.fixedStats().damages().isEmpty()) {
            List<Pair<DamageType, RangedValue>> damages = gearInfo.fixedStats().damages();
            for (Pair<DamageType, RangedValue> damageStat : damages) {
                DamageType damageType = damageStat.key();
                String elementSymbol = damageType.getElement().isPresent() ? damageType.getElement().get().getSymbol() : damageType.getSymbol();
                MutableComponent damage = Component.empty().withStyle(damageType.getColorCode()).append((Component)Component.literal((String)elementSymbol).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))).append((Component)Component.literal((String)(" " + damageType.getDisplayName())));
                damage.append((Component)Component.literal((String)("Damage: " + ((RangedValue)damageStat.value()).asString())).withStyle(damageType == DamageType.NEUTRAL ? damageType.getColorCode() : ChatFormatting.GRAY));
                header.add((Component)damage);
            }
            header.add((Component)Component.literal((String)""));
        }
        if ((health = gearInfo.fixedStats().healthBuff()) != 0) {
            MutableComponent healthComp = Component.literal((String)("\u2764 Health: " + StringUtils.toSignedString(health))).withStyle(ChatFormatting.DARK_RED);
            header.add((Component)healthComp);
        }
        if (!gearInfo.fixedStats().defences().isEmpty()) {
            List<Pair<Element, Integer>> defenses = gearInfo.fixedStats().defences();
            for (Pair pair : defenses) {
                Element element = (Element)((Object)pair.key());
                MutableComponent defense = Component.empty().withStyle(element.getColorCode()).append((Component)Component.literal((String)element.getSymbol()).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))).append((Component)Component.literal((String)(" " + element.getDisplayName())));
                defense.append((Component)Component.literal((String)(" Defence: " + StringUtils.toSignedString((Integer)pair.value()))).withStyle(ChatFormatting.GRAY));
                header.add((Component)defense);
            }
        }
        if (health != 0 || !gearInfo.fixedStats().defences().isEmpty()) {
            header.add((Component)Component.literal((String)""));
        }
        int requirementsCount = 0;
        GearRequirements requirements = gearInfo.requirements();
        if (requirements.classType().isPresent()) {
            ClassType classType = requirements.classType().get();
            boolean fulfilled = Models.Character.getClassType() == classType;
            header.add((Component)this.buildRequirementLine("Class Req: " + classType.getFullName(), fulfilled));
            ++requirementsCount;
        }
        if (requirements.quest().isPresent()) {
            String string = requirements.quest().get();
            Optional<QuestInfo> quest = Models.Quest.getQuestFromName(string);
            boolean fulfilled = quest.isPresent() && quest.get().status() == ActivityStatus.COMPLETED;
            header.add((Component)this.buildRequirementLine("Quest Req: " + string, fulfilled));
            ++requirementsCount;
        }
        if ((n = requirements.level()) != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= n;
            header.add((Component)this.buildRequirementLine("Combat Lv. Min: " + n, fulfilled));
            ++requirementsCount;
        }
        if (!requirements.skills().isEmpty()) {
            for (Pair<Skill, Integer> skillRequirement : requirements.skills()) {
                header.add((Component)this.buildRequirementLine(skillRequirement.key().getDisplayName() + " Min: " + String.valueOf(skillRequirement.value()), false));
                ++requirementsCount;
            }
        }
        if (requirementsCount > 0) {
            header.add((Component)Component.literal((String)""));
        }
        if (gearInstance != null && gearInstance.shinyStat().isPresent()) {
            ShinyStat shinyStat = gearInstance.shinyStat().get();
            if (shinyStat.shinyRerolls() == 0) {
                header.add((Component)Component.literal((String)("\u2b21 " + shinyStat.statType().displayName() + ": ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(shinyStat.value())).withStyle(ChatFormatting.WHITE)));
            } else {
                header.add((Component)Component.literal((String)("\u2b21 " + shinyStat.statType().displayName() + ": ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(shinyStat.value())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" [" + shinyStat.shinyRerolls() + "]")).withStyle(ChatFormatting.DARK_GRAY)));
            }
            header.add((Component)Component.literal((String)""));
        }
        return header;
    }

    @Override
    public List<Component> buildFooterTooltip(GearInfo gearInfo, GearInstance gearInstance, boolean showItemType) {
        Optional<StyledText> lore;
        ArrayList<Component> footer = new ArrayList<Component>();
        if (gearInfo.fixedStats().majorIds().isPresent()) {
            GearMajorId majorId = gearInfo.fixedStats().majorIds().get();
            StyledText lore2 = StyledText.fromComponent((Component)Component.empty().withStyle(ChatFormatting.DARK_AQUA).append((Component)majorId.lore().getComponent()));
            Stream.of(RenderedStringUtils.wrapTextBySize(lore2, 150)).forEach(c -> footer.add((Component)c.getComponent()));
        }
        footer.add((Component)Component.literal((String)""));
        if (gearInfo.powderSlots() > 0) {
            if (gearInstance == null) {
                footer.add((Component)Component.literal((String)("[" + gearInfo.powderSlots() + " Powder Slots]")).withStyle(ChatFormatting.GRAY));
            } else {
                MutableComponent powderLine = Component.literal((String)("[" + gearInstance.powders().size() + "/" + gearInfo.powderSlots() + "] Powder Slots ")).withStyle(ChatFormatting.GRAY);
                if (!gearInstance.powders().isEmpty()) {
                    MutableComponent powderList = Component.literal((String)"[");
                    for (Powder p : gearInstance.powders()) {
                        String symbol = String.valueOf(p.getSymbol());
                        if (!powderList.getSiblings().isEmpty()) {
                            powderList.append((Component)Component.empty().withStyle(Style.EMPTY.withColor(p.getLightColor())).append((Component)Component.literal((String)" ")).append((Component)Component.literal((String)symbol).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))));
                            continue;
                        }
                        powderList.append((Component)Component.literal((String)symbol).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(p.getLightColor())));
                    }
                    powderList.append((Component)Component.literal((String)"]"));
                    powderLine.append((Component)powderList);
                }
                footer.add((Component)powderLine);
            }
        }
        GearTier gearTier = gearInfo.tier();
        MutableComponent itemTypeName = showItemType ? Component.literal((String)StringUtils.capitalizeFirst(gearInfo.type().name().toLowerCase(Locale.ROOT))) : Component.literal((String)"Item");
        MutableComponent tier = Component.literal((String)gearTier.getName()).withStyle(gearTier.getChatFormatting()).append(" ").append((Component)itemTypeName);
        if (gearInstance != null && gearInstance.rerolls() > 1) {
            tier.append(" [" + gearInstance.rerolls() + "]");
        }
        footer.add((Component)tier);
        if (gearInfo.metaInfo().restrictions() != GearRestrictions.NONE) {
            footer.add((Component)Component.literal((String)StringUtils.capitalizeFirst(gearInfo.metaInfo().restrictions().getDescription())).withStyle(ChatFormatting.RED));
        }
        if ((lore = gearInfo.metaInfo().lore()).isPresent()) {
            Stream.of(RenderedStringUtils.wrapTextBySize(lore.get(), 150)).forEach(c -> footer.add((Component)c.getComponent().withStyle(ChatFormatting.DARK_GRAY)));
        }
        return footer;
    }
}

