/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.wynntils.core.components.Managers;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.mc.event.ServerResourcePackEvent;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientCommonPacketListenerImpl.class})
public abstract class ClientCommonPacketListenerImplMixin {
    @Shadow
    @Final
    protected Connection connection;

    @Inject(method={"handleResourcePackPush(Lnet/minecraft/network/protocol/common/ClientboundResourcePackPushPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleResourcePackPushPre(ClientboundResourcePackPushPacket packet, CallbackInfo ci) {
        ServerResourcePackEvent.Load event = new ServerResourcePackEvent.Load(packet.id(), packet.url(), packet.hash(), packet.required());
        MixinHelper.postAlways(event);
        if (event.isCanceled()) {
            this.connection.send((Packet)new ServerboundResourcePackPacket(packet.id(), ServerboundResourcePackPacket.Action.SUCCESSFULLY_LOADED));
            ci.cancel();
        }
    }

    @Inject(method={"handleDisconnect(Lnet/minecraft/network/protocol/common/ClientboundDisconnectPacket;)V"}, at={@At(value="HEAD")})
    private void handleDisconnectPre(ClientboundDisconnectPacket packet, CallbackInfo ci) {
        if (Managers.TickScheduler == null) {
            return;
        }
        Managers.TickScheduler.scheduleNextTick(() -> MixinHelper.postAlways(new ConnectionEvent.DisconnectedEvent("disconnect.packet.listener")));
    }
}

