/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.account;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.container.scriptedquery.QueryBuilder;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class AccountModel
extends Model {
    private static final Pattern SILVERBULL_JOIN_PATTERN = Pattern.compile("\u00a73Welcome to the \u00a7b\u272e Silverbull Trading Company\u00a73!");
    private static final Pattern SILVERBULL_UPDATE_PATTERN = Pattern.compile("\u00a77Your subscription has been extended.");
    private static final Pattern SILVERBULL_PATTERN = Pattern.compile("\u00a78Become a Silverbull Member to");
    private static final Pattern SILVERBULL_DURATION_PATTERN = Pattern.compile("\u00a7#00a2e8ff- \u00a77Expiration: \u00a7f(?:(?<weeks>\\d+) weeks?)? ?(?:(?<days>\\d+) days?)? ?(?:(?<hours>\\d+) hours?)? ?(?:(?<minutes>\\d+) minutes?)? ?(?:(?<seconds>\\d+) seconds?)?");
    public static final Component SILVERBULL_STAR = Component.literal((String)" \u272e").withStyle(ChatFormatting.AQUA);
    private static final int COSMETICS_SLOT = 25;
    private static final int SILVERBULL_SLOT = 36;
    @Persisted
    private final Storage<Long> silverbullExpiresAt = new Storage<Long>(0L);
    @Persisted
    private final Storage<ConfirmedBoolean> silverbullSubscriber = new Storage<ConfirmedBoolean>(ConfirmedBoolean.UNCONFIRMED);

    public AccountModel() {
        super(List.of());
    }

    @SubscribeEvent
    public void onChatReceived(ChatMessageEvent.Match e) {
        StyledText message = e.getMessage().trim();
        if (message.matches(SILVERBULL_JOIN_PATTERN) || message.matches(SILVERBULL_UPDATE_PATTERN)) {
            this.silverbullSubscriber.store(ConfirmedBoolean.TRUE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldStateChanged(WorldStateEvent e) {
        if (e.getNewState() != WorldState.WORLD) {
            return;
        }
        this.scanRankInfo(e.isFirstJoinWorld());
    }

    public boolean isSilverbullSubscriber() {
        return this.silverbullSubscriber.get() == ConfirmedBoolean.TRUE;
    }

    public void scanRankInfo(boolean forceParseUnexpired) {
        WynntilsMod.info("Scheduling rank info query");
        QueryBuilder queryBuilder = ScriptedContainerQuery.builder("Rank Info Query");
        queryBuilder.onError(msg -> WynntilsMod.warn("Error querying Rank Info: " + msg));
        queryBuilder.then(QueryStep.useItemInHotbar(7).expectContainerTitle("\udaff\udfdc\ue003"));
        if (!(forceParseUnexpired || this.silverbullSubscriber.get() == ConfirmedBoolean.UNCONFIRMED || this.silverbullSubscriber.get() != ConfirmedBoolean.FALSE && System.currentTimeMillis() > (Long)this.silverbullExpiresAt.get())) {
            WynntilsMod.info("Skipping silverbull subscription query (" + ((Long)this.silverbullExpiresAt.get() - System.currentTimeMillis()) + " ms left)");
            return;
        }
        queryBuilder.then(QueryStep.clickOnSlot(25).expectContainerTitle("\udaff\udff4\ue02c\udaff\udf7c\uf027\udaff\udf52\udb00\udc3d.\udaff\udf22\udb00\udc40.\udaff\udf2f").processIncomingContainer(this::parseStoreContainer));
        queryBuilder.build().executeQuery();
    }

    private void parseStoreContainer(ContainerContent container) {
        ItemStack silverbullItem = container.items().get(36);
        Matcher status = LoreUtils.matchLoreLine(silverbullItem, 6, SILVERBULL_PATTERN);
        this.silverbullSubscriber.store(status.matches() ? ConfirmedBoolean.FALSE : ConfirmedBoolean.TRUE);
        WynntilsMod.info("Parsed Silverbull subscription status: " + String.valueOf(this.silverbullSubscriber.get()));
        if (this.silverbullSubscriber.get() != ConfirmedBoolean.TRUE) {
            return;
        }
        Matcher expiry = LoreUtils.matchLoreLine(silverbullItem, 7, SILVERBULL_DURATION_PATTERN);
        if (!expiry.matches()) {
            WynntilsMod.warn("Could not parse Silverbull subscription expiry from item: " + String.valueOf(LoreUtils.getLore(silverbullItem)));
            this.silverbullExpiresAt.store(0L);
            return;
        }
        int weeks = expiry.group("weeks") == null ? 0 : Integer.parseInt(expiry.group("weeks"));
        int days = expiry.group("days") == null ? 0 : Integer.parseInt(expiry.group("days"));
        int hours = expiry.group("hours") == null ? 0 : Integer.parseInt(expiry.group("hours"));
        int minutes = expiry.group("minutes") == null ? 0 : Integer.parseInt(expiry.group("minutes"));
        int seconds = expiry.group("seconds") == null ? 0 : Integer.parseInt(expiry.group("seconds"));
        long expiryTime = System.currentTimeMillis() + TimeUnit.DAYS.toMillis((long)weeks * 7L + (long)days) + TimeUnit.HOURS.toMillis(hours) + TimeUnit.MINUTES.toMillis(minutes) + TimeUnit.SECONDS.toMillis(seconds);
        this.silverbullExpiresAt.store(expiryTime);
        WynntilsMod.info("Parsed Silverbull expiry: " + expiryTime);
    }
}

