/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.bonustotems;

import com.wynntils.models.bonustotems.type.BonusTotemType;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;

public class BonusTotem {
    private final BonusTotemType bonusTotemType;
    private final Position position;
    private final String owner;
    private String timerString;

    public BonusTotem(BonusTotemType bonusTotemType, Position position, String owner) {
        this.bonusTotemType = bonusTotemType;
        this.position = position;
        this.owner = owner;
    }

    public BonusTotemType getBuffTotemType() {
        return this.bonusTotemType;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTimerString() {
        return this.timerString;
    }

    public void setTimerString(String timerString) {
        this.timerString = timerString;
    }

    public double getDistanceToPlayer() {
        return Math.sqrt(McUtils.player().distanceToSqr(new Vec3(this.position.x(), this.position.y() - 4.0, this.position.z())));
    }

    public double getLookAngleDiff() {
        Position mobTotemLocation;
        double angle;
        Vec3 playerLook = McUtils.player().getLookAngle();
        double lookAngle = Math.toDegrees(StrictMath.atan2(playerLook.z(), playerLook.x()));
        double angleDiff = lookAngle - (angle = Math.toDegrees(StrictMath.atan2((mobTotemLocation = this.getPosition()).z() - McUtils.player().getZ(), mobTotemLocation.x() - McUtils.player().getX())));
        if (angleDiff < 0.0) {
            angleDiff = 360.0 + angleDiff;
        }
        return angleDiff;
    }
}

