/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.ManaBarSegment;
import java.util.regex.Pattern;

public class ManaBarSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final String BACKGROUND_STRING = "\udb00\udc1c\ue089";
    private static final String LAST_SPACE_STRING = "\udaff\udfa6";
    private static final String MANA_BAR_CHARS = "\ue080-\ue088";
    private static final Pattern MANA_BAR_PATTERN = Pattern.compile("(.[\ue080-\ue088]){10}");

    @Override
    public ActionBarSegment parse(String actionBar) {
        if (!actionBar.contains(BACKGROUND_STRING)) {
            return null;
        }
        int beginIndex = actionBar.indexOf(BACKGROUND_STRING);
        int endIndex = actionBar.indexOf(LAST_SPACE_STRING, beginIndex);
        if (endIndex == -1) {
            WynntilsMod.warn("Found mana bar background, but couldn't find the end of the segment: " + actionBar);
            return null;
        }
        String segmentText = actionBar.substring(beginIndex, endIndex + LAST_SPACE_STRING.length());
        String manaBarText = segmentText.substring(BACKGROUND_STRING.length(), segmentText.length() - LAST_SPACE_STRING.length());
        if (!MANA_BAR_PATTERN.matcher(manaBarText).matches()) {
            WynntilsMod.warn("Mana bar segment seems to match, but the bar text is not expected: " + manaBarText);
            return null;
        }
        return new ManaBarSegment(segmentText);
    }
}

