/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.event.BankPageSetEvent;
import com.wynntils.models.containers.type.PersonalStorageType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class BankModel
extends Model {
    @Persisted
    private final Storage<Integer> finalAccountBankPage = new Storage<Integer>(21);
    @Persisted
    private final Storage<Integer> finalBlockBankPage = new Storage<Integer>(12);
    @Persisted
    private final Storage<Integer> finalBookshelfPage = new Storage<Integer>(10);
    @Persisted
    private final Storage<Integer> finalMiscBucketPage = new Storage<Integer>(10);
    @Persisted
    private final Storage<Map<String, Integer>> finalCharacterBankPages = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, String>> customAccountBankPageNames = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, String>> customBlockBankPageNames = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, String>> customBookshelfPageNames = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, String>> customMiscBucketPageNames = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<String, Map<Integer, String>>> customCharacterBankPagesNames = new Storage(new TreeMap());
    public static final int QUICK_JUMP_SLOT = 7;
    private static final String FINAL_PAGE_NAME = "\udb3f\udfff";
    private static final int MAX_CHARACTER_BANK_PAGES = 10;
    private static final StyledText LAST_BANK_PAGE_STRING = StyledText.fromString(">\u00a74>\u00a7c>\u00a74>\u00a7c>");
    private boolean editingName;
    private boolean updatedPage;
    private int currentPage = 1;
    private PersonalStorageContainer personalStorageContainer = null;
    private PersonalStorageType storageContainerType = null;

    public BankModel() {
        super(List.of());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof PersonalStorageContainer)) {
            this.storageContainerType = null;
            return;
        }
        PersonalStorageContainer container2 = (PersonalStorageContainer)container;
        this.personalStorageContainer = container2;
        this.storageContainerType = this.personalStorageContainer.getPersonalStorageType();
        this.editingName = false;
        this.updatedPage = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScreenClose(ScreenClosedEvent.Post e) {
        this.storageContainerType = null;
        this.currentPage = 1;
        this.editingName = false;
        this.updatedPage = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onContainerSetContent(ContainerSetContentEvent.Pre event) {
        if (this.storageContainerType == null) {
            return;
        }
        ItemStack previousPageItem = event.getItems().get(this.personalStorageContainer.getPreviousItemSlot());
        ItemStack nextPageItem = event.getItems().get(this.personalStorageContainer.getNextItemSlot());
        this.updateState(previousPageItem, nextPageItem);
        this.updatedPage = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        if (this.storageContainerType == null) {
            return;
        }
        if (!this.updatedPage) {
            return;
        }
        if (event.getSlot() == this.personalStorageContainer.getPreviousItemSlot()) {
            this.updateState(event.getItemStack(), ItemStack.EMPTY);
        }
        if (event.getSlot() == this.personalStorageContainer.getNextItemSlot()) {
            this.updateState(ItemStack.EMPTY, event.getItemStack());
        }
    }

    public String getPageName(int page) {
        Map<Integer, String> pageNamesMap = this.getCurrentNameMap();
        if (pageNamesMap == null) {
            return I18n.get((String)"feature.wynntils.personalStorageUtilities.page", (Object[])new Object[]{page});
        }
        return pageNamesMap.getOrDefault(page, I18n.get((String)"feature.wynntils.personalStorageUtilities.page", (Object[])new Object[]{page}));
    }

    public void saveCurrentPageName(String nameToSet) {
        switch (this.storageContainerType) {
            case ACCOUNT_BANK: {
                ((Map)this.customAccountBankPageNames.get()).put(this.currentPage, nameToSet);
                this.customAccountBankPageNames.touched();
                break;
            }
            case BLOCK_BANK: {
                ((Map)this.customBlockBankPageNames.get()).put(this.currentPage, nameToSet);
                this.customBlockBankPageNames.touched();
                break;
            }
            case BOOKSHELF: {
                ((Map)this.customBookshelfPageNames.get()).put(this.currentPage, nameToSet);
                this.customBookshelfPageNames.touched();
                break;
            }
            case CHARACTER_BANK: {
                ((Map)this.customCharacterBankPagesNames.get()).putIfAbsent(Models.Character.getId(), new TreeMap());
                Map nameMap = (Map)((Map)this.customCharacterBankPagesNames.get()).get(Models.Character.getId());
                nameMap.put(this.currentPage, nameToSet);
                ((Map)this.customCharacterBankPagesNames.get()).put(Models.Character.getId(), nameMap);
                this.customCharacterBankPagesNames.touched();
                break;
            }
            case MISC_BUCKET: {
                ((Map)this.customMiscBucketPageNames.get()).put(this.currentPage, nameToSet);
                this.customMiscBucketPageNames.touched();
            }
        }
        this.editingName = false;
    }

    public void resetCurrentPageName() {
        switch (this.storageContainerType) {
            case ACCOUNT_BANK: {
                ((Map)this.customAccountBankPageNames.get()).remove(this.currentPage);
                this.customAccountBankPageNames.touched();
                break;
            }
            case BLOCK_BANK: {
                ((Map)this.customBlockBankPageNames.get()).remove(this.currentPage);
                this.customBlockBankPageNames.touched();
                break;
            }
            case BOOKSHELF: {
                ((Map)this.customBookshelfPageNames.get()).remove(this.currentPage);
                this.customBookshelfPageNames.touched();
                break;
            }
            case CHARACTER_BANK: {
                ((Map)((Map)this.customCharacterBankPagesNames.get()).getOrDefault(Models.Character.getId(), new TreeMap())).remove(this.currentPage);
                this.customCharacterBankPagesNames.touched();
                break;
            }
            case MISC_BUCKET: {
                ((Map)this.customMiscBucketPageNames.get()).remove(this.currentPage);
                this.customMiscBucketPageNames.touched();
            }
        }
        this.editingName = false;
    }

    public int getFinalPage() {
        return switch (this.storageContainerType) {
            default -> throw new MatchException(null, null);
            case PersonalStorageType.ACCOUNT_BANK -> (Integer)this.finalAccountBankPage.get();
            case PersonalStorageType.BLOCK_BANK -> (Integer)this.finalBlockBankPage.get();
            case PersonalStorageType.BOOKSHELF -> (Integer)this.finalBookshelfPage.get();
            case PersonalStorageType.CHARACTER_BANK -> ((Map)this.finalCharacterBankPages.get()).getOrDefault(Models.Character.getId(), 10);
            case PersonalStorageType.MISC_BUCKET -> (Integer)this.finalMiscBucketPage.get();
        };
    }

    public PersonalStorageType getStorageContainerType() {
        return this.storageContainerType;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean isEditingName() {
        return this.editingName;
    }

    public void toggleEditingName(boolean editingName) {
        this.editingName = editingName;
    }

    private void updateState(ItemStack previousPageItem, ItemStack nextPageItem) {
        Matcher nextPageMatcher;
        Matcher previousPageMatcher = StyledText.fromComponent(previousPageItem.getHoverName()).getMatcher(this.personalStorageContainer.getPreviousItemPattern());
        if (previousPageMatcher.matches()) {
            this.currentPage = Integer.parseInt(previousPageMatcher.group(1)) + 1;
        }
        if ((nextPageMatcher = StyledText.fromComponent(nextPageItem.getHoverName()).getMatcher(this.personalStorageContainer.getNextItemPattern())).matches()) {
            this.currentPage = Integer.parseInt(nextPageMatcher.group(1)) - 1;
        }
        if (this.isItemIndicatingLastBankPage(nextPageItem)) {
            this.updateFinalPage();
        }
        WynntilsMod.postEvent(new BankPageSetEvent());
    }

    private boolean isItemIndicatingLastBankPage(ItemStack item) {
        return StyledText.fromComponent(item.getHoverName()).endsWith(LAST_BANK_PAGE_STRING) || item.getHoverName().getString().equals(FINAL_PAGE_NAME);
    }

    private void updateFinalPage() {
        switch (this.storageContainerType) {
            case ACCOUNT_BANK: {
                this.finalAccountBankPage.store(this.currentPage);
                break;
            }
            case BLOCK_BANK: {
                if (this.currentPage <= (Integer)this.finalBlockBankPage.get()) break;
                this.finalBlockBankPage.store(this.currentPage);
                break;
            }
            case BOOKSHELF: {
                this.finalBookshelfPage.store(this.currentPage);
                break;
            }
            case CHARACTER_BANK: {
                ((Map)this.finalCharacterBankPages.get()).put(Models.Character.getId(), this.currentPage);
                this.finalCharacterBankPages.touched();
                break;
            }
            case MISC_BUCKET: {
                this.finalMiscBucketPage.store(this.currentPage);
            }
        }
    }

    private Map<Integer, String> getCurrentNameMap() {
        return switch (this.storageContainerType) {
            default -> throw new MatchException(null, null);
            case PersonalStorageType.ACCOUNT_BANK -> (Map)this.customAccountBankPageNames.get();
            case PersonalStorageType.BLOCK_BANK -> (Map)this.customBlockBankPageNames.get();
            case PersonalStorageType.BOOKSHELF -> (Map)this.customBookshelfPageNames.get();
            case PersonalStorageType.CHARACTER_BANK -> ((Map)this.customCharacterBankPagesNames.get()).getOrDefault(Models.Character.getId(), new TreeMap());
            case PersonalStorageType.MISC_BUCKET -> (Map)this.customMiscBucketPageNames.get();
        };
    }
}

