/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.elements.type;

import com.wynntils.models.elements.type.Element;
import com.wynntils.utils.StringUtils;
import java.util.Locale;
import net.minecraft.ChatFormatting;

public enum Skill {
    STRENGTH(Element.EARTH),
    DEXTERITY(Element.THUNDER),
    INTELLIGENCE(Element.WATER),
    DEFENCE(Element.FIRE),
    AGILITY(Element.AIR);

    private final Element associatedElement;
    private final String apiName;
    private final String displayName;

    private Skill(Element associatedElement) {
        this.associatedElement = associatedElement;
        this.apiName = this.name().toLowerCase(Locale.ROOT);
        this.displayName = StringUtils.capitalized(this.name());
    }

    public static Skill fromString(String str) {
        try {
            return Skill.valueOf(str.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Skill fromApiId(String apiId) {
        String str = apiId.toLowerCase(Locale.ROOT);
        for (Skill skill : Skill.values()) {
            if (!skill.getApiName().equals(str)) continue;
            return skill;
        }
        return null;
    }

    public static Skill fromElement(Element element) {
        for (Skill skill : Skill.values()) {
            if (skill.getAssociatedElement() != element) continue;
            return skill;
        }
        return null;
    }

    public static boolean isSkill(String idName) {
        for (Skill skill : Skill.values()) {
            if (!idName.equals(skill.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public Element getAssociatedElement() {
        return this.associatedElement;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getSymbol() {
        return this.associatedElement.getSymbol();
    }

    public ChatFormatting getColorCode() {
        return this.associatedElement.getColorCode();
    }
}

