/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.Dependency;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearMetaInfo;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.stats.type.FixedStats;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.AbstractItemInfoDeserializer;
import com.wynntils.utils.JsonUtils;
import com.wynntils.utils.type.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class GearInfoRegistry {
    private List<GearInfo> gearInfoRegistry = List.of();
    private Map<String, GearInfo> gearInfoLookup = Map.of();
    private Map<String, GearInfo> gearInfoLookupApiName = Map.of();

    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_GEAR, Dependency.complex(Set.of(Dependency.simple(Models.Set, UrlId.DATA_STATIC_ITEM_SETS), Dependency.simple(Models.WynnItem, UrlId.DATA_STATIC_ITEM_OBTAIN_V2)))).handleJsonObject(this::handleGearInfo);
    }

    public GearInfo getFromDisplayName(String gearName) {
        return this.gearInfoLookup.get(gearName);
    }

    public GearInfo getFromApiName(String apiName) {
        GearInfo gearInfo = this.gearInfoLookupApiName.get(apiName);
        if (gearInfo != null) {
            return gearInfo;
        }
        return this.gearInfoLookup.get(apiName);
    }

    public Stream<GearInfo> getGearInfoStream() {
        return this.gearInfoRegistry.stream();
    }

    private void handleGearInfo(JsonObject json) {
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(GearInfo.class, (Object)new GearInfoDeserializer()).create();
        ArrayList<GearInfo> gearRegistry = new ArrayList<GearInfo>();
        for (Map.Entry entry : json.entrySet()) {
            JsonObject itemObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            itemObject.addProperty("name", (String)entry.getKey());
            GearInfo gearInfo = (GearInfo)gson.fromJson((JsonElement)itemObject, GearInfo.class);
            gearRegistry.add(gearInfo);
        }
        HashMap<String, GearInfo> lookupMap = new HashMap<String, GearInfo>();
        HashMap<String, GearInfo> altLookupMap = new HashMap<String, GearInfo>();
        for (GearInfo gearInfo : gearRegistry) {
            lookupMap.put(gearInfo.name(), gearInfo);
            if (!gearInfo.metaInfo().apiName().isPresent()) continue;
            altLookupMap.put(gearInfo.metaInfo().apiName().get(), gearInfo);
        }
        this.gearInfoRegistry = gearRegistry;
        this.gearInfoLookup = lookupMap;
        this.gearInfoLookupApiName = altLookupMap;
    }

    private static final class GearInfoDeserializer
    extends AbstractItemInfoDeserializer<GearInfo> {
        private GearInfoDeserializer() {
        }

        public GearInfo deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            Pair<String, String> names = this.parseNames(json);
            String displayName = names.key();
            String internalName = names.value();
            GearType type = this.parseType(json);
            if (type == null) {
                throw new RuntimeException("Invalid Wynncraft data: item has no gear type");
            }
            GearTier tier = GearTier.fromString(json.get("rarity").getAsString());
            if (tier == null) {
                throw new RuntimeException("Invalid Wynncraft data: item has no gear tier");
            }
            int powderSlots = JsonUtils.getNullableJsonInt(json, "powderSlots");
            GearMetaInfo metaInfo = this.parseMetaInfo(json, internalName, type);
            GearRequirements requirements = this.parseRequirements(json, type);
            FixedStats fixedStats = this.parseFixedStats(json);
            List<Pair<StatType, StatPossibleValues>> variableStats = this.parseVariableStats(json, "identifications");
            return new GearInfo(displayName, type, tier, powderSlots, metaInfo, requirements, fixedStats, variableStats, Optional.ofNullable(Models.Set.getSetInfoForItem(displayName)));
        }
    }
}

