/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.type;

import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.data.IdentificationData;
import com.wynntils.models.items.encoding.data.TypeData;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.encoding.type.ItemData;
import com.wynntils.models.items.encoding.type.ItemDataMap;
import com.wynntils.models.items.encoding.type.ItemType;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ItemTransformer<T extends WynnItem> {
    public final List<ItemData> encode(T item, EncodingSettings encodingSettings) {
        ArrayList<ItemData> dataList = new ArrayList<ItemData>();
        dataList.add(new TypeData(this.getType()));
        dataList.addAll(this.encodeItem(item, encodingSettings));
        return List.copyOf(dataList);
    }

    public abstract ErrorOr<T> decodeItem(ItemDataMap var1);

    protected abstract List<ItemData> encodeItem(T var1, EncodingSettings var2);

    public abstract ItemType getType();

    protected ErrorOr<Map<StatType, StatActualValue>> processIdentifications(IdentificationData identificationData, List<StatPossibleValues> itemInfoPossibleValues) {
        Map<Object, Object> identifications;
        Map<StatType, StatPossibleValues> statPossibleValues;
        if (identificationData != null) {
            ErrorOr<Void> processResult;
            statPossibleValues = identificationData.possibleValues();
            if (statPossibleValues.isEmpty()) {
                statPossibleValues = itemInfoPossibleValues.stream().collect(Collectors.toMap(StatPossibleValues::statType, Function.identity()));
            }
            if ((processResult = identificationData.processPendingCalculations(statPossibleValues)).hasError()) {
                return ErrorOr.error(processResult.getError());
            }
            identifications = identificationData.identifications().stream().collect(Collectors.toMap(StatActualValue::statType, Function.identity()));
        } else {
            statPossibleValues = itemInfoPossibleValues.stream().collect(Collectors.toMap(StatPossibleValues::statType, Function.identity()));
            identifications = new HashMap();
        }
        for (StatPossibleValues possibleValues : statPossibleValues.values()) {
            if (!possibleValues.isPreIdentified() || identifications.containsKey(possibleValues.statType())) continue;
            identifications.put(possibleValues.statType(), new StatActualValue(possibleValues.statType(), possibleValues.baseValue(), 0, RangedValue.NONE));
        }
        return ErrorOr.of(identifications);
    }
}

