/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.type;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;

public enum MissionType {
    UNKNOWN("Unknown", ChatFormatting.WHITE),
    FAILED("Failed", ChatFormatting.DARK_RED),
    CLEANSING_GREED("Cleansing Greed", ChatFormatting.YELLOW),
    HIGH_ROLLER("High Roller", ChatFormatting.YELLOW, 0, 1),
    HOARDER("Hoarder", ChatFormatting.YELLOW),
    MATERIALISM("Materialism", ChatFormatting.YELLOW),
    GOURMAND("Gourmand", ChatFormatting.BLUE),
    ORPHIONS_GRACE("Orphion's Grace", ChatFormatting.BLUE),
    PORPHYROPHOBIA("Porphyrophobia", ChatFormatting.BLUE),
    CHRONOKINESIS("Chronokinesis", ChatFormatting.BLUE),
    CLEANSING_RITUAL("Cleansing Ritual", ChatFormatting.DARK_PURPLE),
    EQUILIBRIUM("Equilibrium", ChatFormatting.DARK_PURPLE),
    INNER_PEACE("Inner Peace", ChatFormatting.DARK_PURPLE),
    COMPLETE_CHAOS("Complete Chaos", ChatFormatting.DARK_PURPLE),
    JESTERS_TRICK("Jester's Trick", ChatFormatting.DARK_PURPLE),
    INTEREST_SCHEME("Interest Scheme", ChatFormatting.DARK_PURPLE),
    BACKUP_BEAT("Backup Beat", ChatFormatting.GREEN),
    STASIS("Stasis", ChatFormatting.GREEN),
    OPTIMISM("Optimism", ChatFormatting.GREEN),
    REDEMPTION("Redemption", ChatFormatting.RED, 1, 0),
    THRILL_SEEKER("Thrill Seeker", ChatFormatting.RED);

    private final String name;
    private final ChatFormatting color;
    private final int sacrifices;
    private final int rerolls;

    private MissionType(String name, ChatFormatting color) {
        this.name = name;
        this.color = color;
        this.sacrifices = 0;
        this.rerolls = 0;
    }

    private MissionType(String name, ChatFormatting color, int sacrifices, int rerolls) {
        this.name = name;
        this.color = color;
        this.sacrifices = sacrifices;
        this.rerolls = rerolls;
    }

    public String getName() {
        return this.name;
    }

    public String getColoredName() {
        return String.valueOf(this.color) + this.name;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public int getSacrifices() {
        return this.sacrifices;
    }

    public int getRerolls() {
        return this.rerolls;
    }

    public static MissionType fromName(String name) {
        for (MissionType type : MissionType.values()) {
            if (type == UNKNOWN || type == FAILED || !type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static List<MissionType> missionTypes() {
        return Arrays.stream(MissionType.values()).filter(type -> type != UNKNOWN && type != FAILED).toList();
    }
}

