/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.marker;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.features.map.WorldWaypointDistanceFeature;
import com.wynntils.models.marker.type.LocationSupplier;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.models.marker.type.MarkerProvider;
import com.wynntils.models.marker.type.StaticLocationSupplier;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.type.Pair;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;

public class UserWaypointMarkerProvider
implements MarkerProvider<WaypointPoi> {
    private final Set<Pair<MarkerInfo, WaypointPoi>> markerInfoSet = new CopyOnWriteArraySet<Pair<MarkerInfo, WaypointPoi>>();

    public void addLocation(Location location, Texture texture, CustomColor beaconColor, CustomColor textColor, String additonalText) {
        this.addLocation(new MarkerInfo("Waypoint", new StaticLocationSupplier(location), texture, beaconColor, textColor, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? additonalText : null));
    }

    public void addLocation(Location location, Texture texture, CustomColor beaconColor, String additonalText) {
        this.addLocation(new MarkerInfo("Waypoint", new StaticLocationSupplier(location), texture, beaconColor, CommonColors.WHITE, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? Models.Activity.getTrackedName() : null));
    }

    public void addLocation(Location location, Texture texture, String additionalText) {
        this.addLocation(new MarkerInfo("Waypoint", new StaticLocationSupplier(location), texture, CustomColor.NONE, CommonColors.WHITE, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? additionalText : null));
    }

    public void addLocation(Location location, String additonalText) {
        this.addLocation(new MarkerInfo("Waypoint", new StaticLocationSupplier(location), Texture.WAYPOINT, CustomColor.NONE, CommonColors.WHITE, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? additonalText : null));
    }

    public void addLocation(LocationSupplier locationSupplier, String additonalText) {
        this.addLocation(new MarkerInfo("Waypoint", locationSupplier, Texture.WAYPOINT, CustomColor.NONE, CommonColors.WHITE, CommonColors.WHITE, (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? additonalText : null));
    }

    private void addLocation(MarkerInfo markerInfo) {
        this.markerInfoSet.add(Pair.of(markerInfo, new WaypointPoi(() -> PoiLocation.fromLocation(markerInfo.locationSupplier().getLocation()), markerInfo.name())));
    }

    public void removeLocation(Location location) {
        this.markerInfoSet.removeIf(info -> ((MarkerInfo)info.a()).location().equals(location));
    }

    public void removeAllLocations() {
        this.markerInfoSet.clear();
    }

    @Override
    public Stream<WaypointPoi> getPois() {
        return this.markerInfoSet.stream().map(Pair::b);
    }

    @Override
    public Stream<MarkerInfo> getMarkerInfos() {
        return this.markerInfoSet.stream().map(Pair::a);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

