/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.profession.type;

import com.wynntils.core.persisted.config.NullableConfig;
import java.util.List;
import java.util.Locale;

public enum ProfessionType implements NullableConfig
{
    WOODCUTTING("Woodcutting", "\u24b8"),
    MINING("Mining", "\u24b7"),
    FISHING("Fishing", "\u24c0"),
    FARMING("Farming", "\u24bf"),
    ALCHEMISM("Alchemism", "\u24c1"),
    ARMOURING("Armouring", "\u24bd"),
    COOKING("Cooking", "\u24b6"),
    JEWELING("Jeweling", "\u24b9"),
    SCRIBING("Scribing", "\u24ba"),
    TAILORING("Tailoring", "\u24bb"),
    WEAPONSMITHING("Weaponsmithing", "\u24bc"),
    WOODWORKING("Woodworking", "\u24be");

    private final String professionName;
    private final String professionIconChar;

    private ProfessionType(String professionName, String professionIconChar) {
        this.professionName = professionName;
        this.professionIconChar = professionIconChar;
    }

    public String getDisplayName() {
        return this.professionName;
    }

    public String getProfessionIconChar() {
        return this.professionIconChar;
    }

    public static ProfessionType fromString(String type) {
        try {
            return ProfessionType.valueOf(type.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<ProfessionType> craftingProfessionTypes() {
        return List.of(ALCHEMISM, ARMOURING, COOKING, JEWELING, SCRIBING, TAILORING, WEAPONSMITHING, WOODWORKING);
    }
}

