/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.spells.type;

import com.wynntils.core.components.Models;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.spells.type.SpellDirection;
import java.util.Arrays;

public enum SpellType {
    ARROW_STORM(ClassType.ARCHER, 1, "Arrow Storm", 6, 0),
    ESCAPE(ClassType.ARCHER, 2, "Escape", 3, 0),
    BOMB(ClassType.ARCHER, 3, "Arrow Bomb", 8, 0),
    ARROW_SHIELD(ClassType.ARCHER, 4, "Arrow Shield", 8, 1),
    SPIN_ATTACK(ClassType.ASSASSIN, 1, "Spin Attack", 6, 0),
    DASH(ClassType.ASSASSIN, 2, "Dash", 2, 0),
    MULTI_HIT(ClassType.ASSASSIN, 3, "Multi Hit", 8, 0),
    SMOKE_BOMB(ClassType.ASSASSIN, 4, "Smoke Bomb", 8, 0),
    BASH(ClassType.WARRIOR, 1, "Bash", 6, 0),
    CHARGE(ClassType.WARRIOR, 2, "Charge", 4, 0),
    UPPERCUT(ClassType.WARRIOR, 3, "Uppercut", 9, 0),
    WAR_SCREAM(ClassType.WARRIOR, 4, "War Scream", 7, -1),
    HEAL(ClassType.MAGE, 1, "Heal", 8, -1),
    TELEPORT(ClassType.MAGE, 2, "Teleport", 4, 0),
    METEOR(ClassType.MAGE, 3, "Meteor", 8, 0),
    ICE_SNAKE(ClassType.MAGE, 4, "Ice Snake", 6, -1),
    TOTEM(ClassType.SHAMAN, 1, "Totem", 4, 0),
    HAUL(ClassType.SHAMAN, 2, "Haul", 3, -1),
    AURA(ClassType.SHAMAN, 3, "Aura", 8, 0),
    UPROOT(ClassType.SHAMAN, 4, "Uproot", 6, 0),
    FIRST_SPELL(ClassType.NONE, 1, "1st Spell", 0, 0),
    SECOND_SPELL(ClassType.NONE, 2, "2nd Spell", 0, 0),
    THIRD_SPELL(ClassType.NONE, 3, "3rd Spell", 0, 0),
    FOURTH_SPELL(ClassType.NONE, 4, "4th Spell", 0, 0);

    public static final int MAX_SPELL = 4;
    private static final SpellDirection[] RLR;
    private static final SpellDirection[] RRR;
    private static final SpellDirection[] RLL;
    private static final SpellDirection[] RRL;
    private static final SpellDirection[] LRL;
    private static final SpellDirection[] LLL;
    private static final SpellDirection[] LRR;
    private static final SpellDirection[] LLR;
    private final ClassType classType;
    private final int spellNumber;
    private final String name;
    private final int startManaCost;
    private final int gradeManaChange;

    public ClassType getClassType() {
        return this.classType;
    }

    public int getSpellNumber() {
        return this.spellNumber;
    }

    public String getName() {
        return this.name;
    }

    private SpellType(ClassType classType, int spellNumber, String name, int startManaCost, int gradeManaChange) {
        this.classType = classType;
        this.spellNumber = spellNumber;
        this.name = name;
        this.startManaCost = startManaCost;
        this.gradeManaChange = gradeManaChange;
    }

    public static SpellType fromName(String name) {
        for (SpellType spellType : SpellType.values()) {
            if (!name.startsWith(spellType.name) || name.length() != spellType.name.length() && !String.valueOf(name.charAt(spellType.name.length())).isBlank()) continue;
            return spellType;
        }
        return null;
    }

    public SpellType forOtherClass(ClassType otherClass) {
        return SpellType.forClass(otherClass, this.getSpellNumber());
    }

    public static SpellType forClass(ClassType classRequired, int spellNumber) {
        for (SpellType spellType : SpellType.values()) {
            if (spellType.classType != classRequired || spellType.spellNumber != spellNumber) continue;
            return spellType;
        }
        return null;
    }

    public String getGenericName() {
        return SpellType.forClass(ClassType.NONE, this.getSpellNumber()).getName();
    }

    public String getGenericAndSpecificName() {
        return this.getGenericName() + " (" + this.getName() + ")";
    }

    public static SpellType fromSpellDirectionArray(SpellDirection[] casted) {
        int spellNumber = 4;
        if (Arrays.equals((Object[])casted, (Object[])RLR) || Arrays.equals((Object[])casted, (Object[])LRL)) {
            spellNumber = 1;
        } else if (Arrays.equals((Object[])casted, (Object[])RRR) || Arrays.equals((Object[])casted, (Object[])LLL)) {
            spellNumber = 2;
        } else if (Arrays.equals((Object[])casted, (Object[])RLL) || Arrays.equals((Object[])casted, (Object[])LRR)) {
            spellNumber = 3;
        }
        return SpellType.forClass(Models.Character.getClassType(), spellNumber);
    }

    static {
        RLR = new SpellDirection[]{SpellDirection.RIGHT, SpellDirection.LEFT, SpellDirection.RIGHT};
        RRR = new SpellDirection[]{SpellDirection.RIGHT, SpellDirection.RIGHT, SpellDirection.RIGHT};
        RLL = new SpellDirection[]{SpellDirection.RIGHT, SpellDirection.LEFT, SpellDirection.LEFT};
        RRL = new SpellDirection[]{SpellDirection.RIGHT, SpellDirection.RIGHT, SpellDirection.LEFT};
        LRL = SpellDirection.invertArray(RLR);
        LLL = SpellDirection.invertArray(RRR);
        LRR = SpellDirection.invertArray(RLL);
        LLR = SpellDirection.invertArray(RRL);
    }
}

