/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.token;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.event.EntityLabelEvent;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.models.inventory.InventoryWatcher;
import com.wynntils.models.items.items.game.MiscItem;
import com.wynntils.models.token.event.TokenGatekeeperEvent;
import com.wynntils.models.token.type.TokenGatekeeper;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.mc.PosUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.TimedSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Position;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class TokenModel
extends Model {
    private static final Pattern TOA_GATEKEEPER_NAME_PATTERN = Pattern.compile("^\u00a72Floormaster \\[Floor (\\d+), Level (\\d+)\\]$");
    private static final Pattern HIVE_GATEKEEPER_NAME_PATTERN = Pattern.compile("^\u00a72(.*) Catalyst Collector (\\d+)$");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^\u00a7a(\\d+)\u00a72/(\\d+)(?:\u00a7r)?$");
    private static final Pattern TYPE_PATTERN = Pattern.compile("^\u00a77Get \u00a7[e6]\\[(?:(\\d+) )?(.*)\\]$");
    private static final StyledText VERIFICATION_STRING = StyledText.fromString("\u00a77Right-click to add");
    private final Map<Integer, TokenGatekeeper> activeGatekeepers = new HashMap<Integer, TokenGatekeeper>();
    private final Map<TokenGatekeeper, TokenInventoryWatcher> inventoryWatchers = new HashMap<TokenGatekeeper, TokenInventoryWatcher>();
    private final TimedSet<BakingTokenGatekeeper> bakingGatekeepers = new TimedSet(5L, TimeUnit.SECONDS, true);
    private final Map<Integer, TokenGatekeeper> invisibleGatekeepers = new HashMap<Integer, TokenGatekeeper>();

    public TokenModel() {
        super(List.of());
    }

    public List<TokenGatekeeper> getGatekeepers() {
        return this.activeGatekeepers.values().stream().sorted().toList();
    }

    public int inInventory(TokenGatekeeper gatekeeper) {
        TokenInventoryWatcher watcher = this.inventoryWatchers.get(gatekeeper);
        int inventoryCount = watcher != null ? watcher.getTotalCount() : 0;
        return inventoryCount;
    }

    public CappedValue getCollected(TokenGatekeeper gatekeeper) {
        TokenInventoryWatcher watcher = this.inventoryWatchers.get(gatekeeper);
        int inventoryCount = watcher != null ? watcher.getTotalCount() : 0;
        CappedValue deposited = gatekeeper.getDeposited();
        int total = Math.min(deposited.current() + inventoryCount, deposited.max());
        return new CappedValue(total, deposited.max());
    }

    @SubscribeEvent
    public void onLabelChange(EntityLabelEvent.Changed event) {
        Matcher hiveMatcher;
        if (!(event.getEntity() instanceof ArmorStand)) {
            return;
        }
        StyledText name = event.getName();
        Matcher typeMatcher = name.getMatcher(TYPE_PATTERN);
        if (typeMatcher.matches()) {
            String countString = typeMatcher.group(1);
            int max = countString != null ? Integer.parseInt(countString) : 1;
            StyledText type = StyledText.fromString(typeMatcher.group(2));
            BakingTokenGatekeeper baking = this.getBaking((Position)event.getEntity().position());
            baking.type = type;
            baking.typeMax = max;
            if (baking.valueEntityId == 0) {
                baking.valueEntityId = event.getEntity().getId();
            }
            this.checkAndPromoteBaking();
            return;
        }
        Matcher tokensMatcher = name.getMatcher(TOKEN_PATTERN);
        if (tokensMatcher.matches()) {
            CappedValue tokens = new CappedValue(Integer.parseInt(tokensMatcher.group(1)), Integer.parseInt(tokensMatcher.group(2)));
            int id = event.getEntity().getId();
            TokenGatekeeper gatekeeper = this.activeGatekeepers.get(id);
            if (gatekeeper != null) {
                gatekeeper.setDeposited(tokens);
                WynntilsMod.postEvent(new TokenGatekeeperEvent.Deposited(gatekeeper));
                return;
            }
            TokenGatekeeper invisibleGatekeeper = this.invisibleGatekeepers.get(id);
            if (invisibleGatekeeper != null) {
                invisibleGatekeeper.setDeposited(tokens);
                return;
            }
            BakingTokenGatekeeper baking = this.getBaking((Position)event.getEntity().position());
            baking.value = tokens;
            baking.valueEntityId = event.getEntity().getId();
            this.checkAndPromoteBaking();
            return;
        }
        if (name.equals(VERIFICATION_STRING)) {
            BakingTokenGatekeeper baking = this.getBaking((Position)event.getEntity().position());
            baking.confirmed = true;
            this.checkAndPromoteBaking();
            return;
        }
        Matcher toaMatcher = name.getMatcher(TOA_GATEKEEPER_NAME_PATTERN);
        if (toaMatcher.matches()) {
            int floor = Integer.parseInt(toaMatcher.group(1));
            int level = Integer.parseInt(toaMatcher.group(2));
            int maxTokens = level == 10 ? 1 : 5;
            Location location = Location.containing((Position)event.getEntity().position()).offset(0, 3, 0);
            StyledText gatekeeperTokenName = StyledText.fromString("Shard [Floor " + floor + " - Level " + level + "]");
            StyledText itemName = StyledText.fromString("\u00a7d[Floor " + floor + " - Lv. " + level + "]");
            this.addGatekeeper(event.getEntity().getId(), new TokenGatekeeper(gatekeeperTokenName, itemName, location, new CappedValue(0, maxTokens)));
        }
        if ((hiveMatcher = name.getMatcher(HIVE_GATEKEEPER_NAME_PATTERN)).matches()) {
            String division = hiveMatcher.group(1);
            int level = Integer.parseInt(hiveMatcher.group(2));
            int maxTokens = level == 10 ? 1 : 5;
            Location location = Location.containing((Position)event.getEntity().position()).offset(0, 3, 0);
            StyledText tokenName = StyledText.fromString(division + " Catalyst " + MathUtils.toRoman(level));
            this.addGatekeeper(event.getEntity().getId(), new TokenGatekeeper(tokenName, location, new CappedValue(0, maxTokens)));
        }
    }

    @SubscribeEvent
    public void onLabelVisibility(EntityLabelEvent.Visibility event) {
        if (!event.getVisibility()) {
            int id = event.getEntity().getId();
            TokenGatekeeper gatekeeper = this.activeGatekeepers.get(id);
            if (gatekeeper == null) {
                return;
            }
            this.removeGatekeeper(id, gatekeeper);
            this.invisibleGatekeepers.put(id, gatekeeper);
        } else {
            int id = event.getEntity().getId();
            TokenGatekeeper gatekeeper = this.invisibleGatekeepers.get(id);
            if (gatekeeper == null) {
                return;
            }
            this.invisibleGatekeepers.remove(id);
            this.addGatekeeper(id, gatekeeper);
        }
    }

    @SubscribeEvent
    public void onEntitiesRemoved(RemoveEntitiesEvent event) {
        for (int id : event.getEntityIds()) {
            if (this.activeGatekeepers.containsKey(id)) {
                this.removeGatekeeper(id, this.activeGatekeepers.get(id));
            }
            this.invisibleGatekeepers.remove(id);
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent event) {
        this.inventoryWatchers.values().forEach(Models.Inventory::unregisterWatcher);
        HashSet<TokenGatekeeper> oldGatekeepers = new HashSet<TokenGatekeeper>(this.activeGatekeepers.values());
        this.activeGatekeepers.clear();
        this.invisibleGatekeepers.clear();
        this.bakingGatekeepers.clear();
        this.inventoryWatchers.clear();
        oldGatekeepers.forEach(gatekeeper -> WynntilsMod.postEvent(new TokenGatekeeperEvent.Removed((TokenGatekeeper)gatekeeper)));
    }

    private void addGatekeeper(int entityId, TokenGatekeeper gatekeeper) {
        TokenInventoryWatcher watcher = new TokenInventoryWatcher(gatekeeper);
        this.inventoryWatchers.put(gatekeeper, watcher);
        Models.Inventory.registerWatcher(watcher);
        this.activeGatekeepers.put(entityId, gatekeeper);
        WynntilsMod.postEvent(new TokenGatekeeperEvent.Added(gatekeeper));
    }

    private void removeGatekeeper(int entityId, TokenGatekeeper gatekeeper) {
        this.activeGatekeepers.remove(entityId);
        InventoryWatcher watcher = this.inventoryWatchers.get(gatekeeper);
        Models.Inventory.unregisterWatcher(watcher);
        this.inventoryWatchers.remove(gatekeeper);
        WynntilsMod.postEvent(new TokenGatekeeperEvent.Removed(gatekeeper));
    }

    private BakingTokenGatekeeper getBaking(Position position) {
        for (BakingTokenGatekeeper baking : this.bakingGatekeepers) {
            if (!PosUtils.isSame(position, baking.position)) continue;
            return baking;
        }
        BakingTokenGatekeeper baking = new BakingTokenGatekeeper(position);
        this.bakingGatekeepers.put(baking);
        return baking;
    }

    private void checkAndPromoteBaking() {
        Iterator<BakingTokenGatekeeper> iter = this.bakingGatekeepers.iterator();
        while (iter.hasNext()) {
            BakingTokenGatekeeper baking = iter.next();
            if (baking.valueEntityId == 0 || baking.type == null || (!baking.confirmed || baking.value == null) && baking.typeMax != 1) continue;
            iter.remove();
            this.addGatekeeper(baking.valueEntityId, baking.toGatekeeper());
        }
    }

    private static final class TokenInventoryWatcher
    extends InventoryWatcher {
        private final TokenGatekeeper gatekeeper;

        private TokenInventoryWatcher(TokenGatekeeper gatekeeper, StyledText tokenItemName) {
            super((ItemStack itemStack) -> TokenInventoryWatcher.isToken(tokenItemName, itemStack));
            this.gatekeeper = gatekeeper;
        }

        private TokenInventoryWatcher(TokenGatekeeper gatekeeper) {
            this(gatekeeper, gatekeeper.getItemTokenName());
        }

        private static boolean isToken(StyledText tokenItemName, ItemStack itemStack) {
            Optional<MiscItem> miscItemOpt = Models.Item.asWynnItem(itemStack, MiscItem.class);
            if (miscItemOpt.isEmpty()) {
                return false;
            }
            MiscItem miscItem = miscItemOpt.get();
            if (!miscItem.isUntradable()) {
                return false;
            }
            return miscItem.getName().contains(tokenItemName);
        }

        @Override
        protected void onUpdate(int oldSlots, int oldTotalCount) {
            WynntilsMod.postEvent(new TokenGatekeeperEvent.InventoryUpdated(this.gatekeeper, this.getTotalCount(), oldTotalCount));
        }
    }

    private static final class BakingTokenGatekeeper {
        private final Position position;
        private StyledText type;
        private int typeMax;
        private CappedValue value;
        private int valueEntityId;
        private boolean confirmed;

        private BakingTokenGatekeeper(Position position) {
            this.position = position;
        }

        private TokenGatekeeper toGatekeeper() {
            Location location = Location.containing(this.position).offset(0, 3, 0);
            if (this.typeMax == 1) {
                return new TokenGatekeeper(this.type, location, new CappedValue(0, 1));
            }
            return new TokenGatekeeper(this.type, location, this.value);
        }
    }
}

