/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.territories.GuildAttackScoreboardPart;
import com.wynntils.models.territories.TerritoryAttackTimer;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Comparator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class TerritoryAttackTimerOverlay
extends Overlay {
    @Persisted
    private final Config<Boolean> disableAttackTimersOnScoreboard = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    private TextRenderSetting textRenderSetting;

    public TerritoryAttackTimerOverlay() {
        super(new OverlayPosition(165.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(250.0f, 110.0f), HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
        this.updateTextRenderSetting();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disableAttackTimersOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof GuildAttackScoreboardPart) {
            event.setCanceled(true);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), Models.GuildAttackTimer.getAttackTimers().stream().sorted(Comparator.comparing(TerritoryAttackTimer::asSeconds)).map(territoryAttackTimer -> new TextRenderTask(territoryAttackTimer.asString(), this.textRenderSetting)).toList(), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), new TextRenderTask(String.valueOf(ChatFormatting.GRAY) + "Detlas" + String.valueOf(ChatFormatting.RED) + " (High)" + String.valueOf(ChatFormatting.AQUA) + " 02:31", this.textRenderSetting), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSetting();
    }

    private void updateTextRenderSetting() {
        this.textRenderSetting = TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get());
    }
}

