/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.gamebars;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.bossbar.type.BossBarProgress;
import com.wynntils.models.abilities.AbilityModel;
import com.wynntils.models.abilities.bossbars.CommanderBar;
import com.wynntils.overlays.gamebars.BaseBarOverlay;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.renderer.MultiBufferSource;

public class CommanderBarOverlay
extends BaseBarOverlay {
    @Persisted
    private final Config<CustomColor> activatedColor = new Config<CustomColor>(CommonColors.GREEN);

    public CommanderBarOverlay() {
        super(new OverlayPosition(-30.0f, -150.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(81.0f, 21.0f), CommonColors.RED);
    }

    @Override
    public BossBarProgress progress() {
        return AbilityModel.commanderBar.getBarProgress();
    }

    @Override
    protected Class<? extends TrackedBar> getTrackedBarClass() {
        return CommanderBar.class;
    }

    @Override
    public boolean isVisible() {
        return AbilityModel.commanderBar.isActive();
    }

    @Override
    protected String text() {
        return "Commander: " + AbilityModel.commanderBar.getDuration() + "s";
    }

    @Override
    protected void renderBar(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, float renderHeight, float progress) {
        Texture universalBarTexture = Texture.UNIVERSAL_BAR;
        BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, universalBarTexture, AbilityModel.commanderBar.isActivated() ? (CustomColor)this.activatedColor.get() : (CustomColor)this.textColor.get(), this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, ((UniversalTexture)this.barTexture.get()).getTextureY1(), universalBarTexture.width(), ((UniversalTexture)this.barTexture.get()).getTextureY2(), progress);
    }

    @Override
    protected void renderText(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, String text) {
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(text), this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, 0.0f, AbilityModel.commanderBar.isActivated() ? (CustomColor)this.activatedColor.get() : (CustomColor)this.textColor.get(), this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
    }
}

