/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.activities.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class WynntilsMenuTag
extends WynntilsButton {
    private final Consumer<Integer> onClick;
    private int offset = 0;

    public WynntilsMenuTag(int x, int y, Consumer<Integer> onClick) {
        super(x, y, Texture.CONTENT_BOOK_TAG.width(), 22, (Component)Component.literal((String)"Wynntils Menu Button"));
        this.onClick = onClick;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.offset = this.isHovered ? Math.min(2, this.offset + 1) : Math.max(0, this.offset - 1);
        RenderUtils.drawTexturedRect(poseStack, Texture.CONTENT_BOOK_TAG.resource(), this.getX(), this.getY(), 0.0f, Texture.CONTENT_BOOK_TAG.width(), this.height, 0, this.height * this.offset, Texture.CONTENT_BOOK_TAG.width(), this.height, Texture.CONTENT_BOOK_TAG.width(), Texture.CONTENT_BOOK_TAG.height());
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.name")), (float)this.getX() + (float)this.width / 2.0f + (float)this.offset, (float)this.getY() + (float)this.height / 2.0f - 2.0f, this.isHovered ? CommonColors.YELLOW : CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        this.onClick.accept(button);
        return true;
    }

    public void onPress() {
    }
}

