/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public abstract class WynntilsMenuScreenBase
extends WynntilsScreen {
    private static final ResourceLocation BOOK_OPEN_ID = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"ui.book.open");
    private static final SoundEvent BOOK_OPEN_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)BOOK_OPEN_ID);
    protected int offsetX;
    protected int offsetY;

    protected WynntilsMenuScreenBase(Component component) {
        super(component);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.width - Texture.CONTENT_BOOK_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.CONTENT_BOOK_BACKGROUND.height()) / 2.0f);
    }

    public static void openBook(Screen screen) {
        McUtils.mc().setScreen(screen);
        McUtils.playSoundUI(BOOK_OPEN_SOUND);
    }

    protected void renderBackgroundTexture(PoseStack poseStack) {
        RenderUtils.drawTexturedRect(poseStack, Texture.CONTENT_BOOK_BACKGROUND, this.offsetX, this.offsetY);
    }

    protected void renderVersion(PoseStack poseStack) {
        String version = WynntilsMod.isDevelopmentBuild() ? "Development Build" : WynntilsMod.getVersion();
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(version), (float)(54 + this.offsetX), (float)(127 + this.offsetX), (float)(196 + this.offsetY), (float)(202 + this.offsetY), 0.0f, CommonColors.YELLOW, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 0.7f);
    }

    protected void renderTitle(PoseStack poseStack, String titleString) {
        RenderUtils.drawTexturedRect(poseStack, Texture.CONTENT_BOOK_TITLE, this.offsetX, 30 + this.offsetY);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(titleString), (float)(10 + this.offsetX), (float)(36 + this.offsetY), CommonColors.YELLOW, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.0f);
    }

    protected void renderDescription(PoseStack poseStack, String description, String filterHelper) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(description), (float)(20 + this.offsetX), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 10.0f + (float)this.offsetX, (float)(80 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, TextShadow.NONE);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(filterHelper), (float)(20 + this.offsetX), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 10.0f + (float)this.offsetY, (float)(105 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, TextShadow.NONE);
    }
}

