/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class FilterButton
extends WynntilsButton
implements TooltipProvider {
    private static final Component DEFAULT_ENABLED_TOOLTIP = Component.translatable((String)"screens.wynntils.content.clickToHide").withStyle(ChatFormatting.GRAY);
    private static final Component DEFAULT_DISABLED_TOOLTIP = Component.translatable((String)"screens.wynntils.content.clickToShow").withStyle(ChatFormatting.GRAY);
    private static final CustomColor BUTTON_COLOR = new CustomColor(181, 174, 151);
    private static final CustomColor BUTTON_COLOR_HOVERED = new CustomColor(121, 116, 101);
    private static final CustomColor BUTTON_COLOR_ENABLED = new CustomColor(164, 212, 142);
    private final Texture texture;
    private final boolean dynamicTexture;
    private final List<Component> tooltipList;
    private final List<Component> enabledActionTooltip;
    private final List<Component> disabledActionTooltip;
    private final Runnable onPress;
    private final Supplier<Boolean> isEnabled;

    public FilterButton(int x, int y, int width, int height, Texture texture, boolean dynamicTexture, List<Component> tooltipList, Runnable onPress, Supplier<Boolean> isEnabled) {
        super(x, y, width, height, (Component)Component.literal((String)"Filter Button"));
        this.texture = texture;
        this.dynamicTexture = dynamicTexture;
        this.tooltipList = tooltipList;
        this.enabledActionTooltip = List.of(DEFAULT_ENABLED_TOOLTIP);
        this.disabledActionTooltip = List.of(DEFAULT_DISABLED_TOOLTIP);
        this.onPress = onPress;
        this.isEnabled = isEnabled;
    }

    public FilterButton(int x, int y, int width, int height, Texture texture, boolean dynamicTexture, List<Component> tooltipList, List<Component> enabledActionTooltip, List<Component> disabledActionTooltip, Runnable onPress, Supplier<Boolean> isEnabled) {
        super(x, y, width, height, (Component)Component.literal((String)"Filter Button"));
        this.texture = texture;
        this.dynamicTexture = dynamicTexture;
        this.tooltipList = tooltipList;
        this.enabledActionTooltip = enabledActionTooltip;
        this.disabledActionTooltip = disabledActionTooltip;
        this.onPress = onPress;
        this.isEnabled = isEnabled;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, this.getButtonColor(), this.getX(), this.getY(), 0.0f, this.width, this.height);
        if (!this.dynamicTexture) {
            RenderUtils.drawTexturedRect(poseStack, this.texture.resource(), (float)this.getX() + (float)(this.width - this.texture.width()) / 2.0f, (float)this.getY() + (float)(this.height - this.texture.height()) / 2.0f, 1.0f, this.texture.width(), this.texture.height(), 0, 0, this.texture.width(), this.texture.height(), this.texture.width(), this.texture.height());
        } else if (this.isHovered) {
            RenderUtils.drawTexturedRect(poseStack, this.texture.resource(), (float)this.getX() + (float)(this.width - this.texture.width()) / 2.0f, (float)this.getY() + ((float)this.height - (float)this.texture.height() / 2.0f) / 2.0f, 1.0f, this.texture.width(), (float)this.texture.height() / 2.0f, 0, this.texture.height() / 2, this.texture.width(), this.texture.height() / 2, this.texture.width(), this.texture.height());
        } else {
            RenderUtils.drawTexturedRect(poseStack, this.texture.resource(), (float)this.getX() + (float)(this.width - this.texture.width()) / 2.0f, (float)this.getY() + ((float)this.height - (float)this.texture.height() / 2.0f) / 2.0f, 1.0f, this.texture.width(), (float)this.texture.height() / 2.0f, 0, 0, this.texture.width(), this.texture.height() / 2, this.texture.width(), this.texture.height());
        }
    }

    private CustomColor getButtonColor() {
        if (this.isEnabled.get().booleanValue()) {
            return BUTTON_COLOR_ENABLED;
        }
        return this.isHovered ? BUTTON_COLOR_HOVERED : BUTTON_COLOR;
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> renderedTooltip = new ArrayList<Component>(this.tooltipList);
        if (this.isEnabled.get().booleanValue()) {
            renderedTooltip.addAll(this.enabledActionTooltip);
        } else {
            renderedTooltip.addAll(this.disabledActionTooltip);
        }
        return renderedTooltip;
    }

    public void onPress() {
        this.onPress.run();
    }
}

