/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class TextInputBoxWidget
extends AbstractWidget {
    private static final Component DEFAULT_TEXT = Component.translatable((String)"screens.wynntils.textInputWidget.defaultText");
    private static final int CURSOR_PADDING = 3;
    private static final int CURSOR_TICK = 350;
    private final Consumer<String> onUpdateConsumer;
    protected List<Component> tooltip;
    protected String textBoxInput = "";
    protected int cursorPosition = 0;
    private int highlightPosition = 0;
    private long lastCursorSwitch = 0L;
    private boolean renderCursor = true;
    private CustomColor renderColor = CommonColors.WHITE;
    protected boolean isDragging = false;
    protected final TextboxScreen textboxScreen;
    protected int textPadding = 2;

    protected TextInputBoxWidget(int x, int y, int width, int height, Component boxTitle, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        super(x, y, width, height, boxTitle);
        this.onUpdateConsumer = onUpdateConsumer == null ? this::onUpdate : onUpdateConsumer;
        this.textboxScreen = textboxScreen;
    }

    public TextInputBoxWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen, TextInputBoxWidget oldWidget) {
        this(x, y, width, height, (Component)Component.empty(), onUpdateConsumer, textboxScreen);
        if (oldWidget != null) {
            this.textBoxInput = oldWidget.textBoxInput;
            this.setCursorAndHighlightPositions(oldWidget.cursorPosition);
            this.renderColor = oldWidget.renderColor;
        }
    }

    public TextInputBoxWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        this(x, y, width, height, onUpdateConsumer, textboxScreen, null);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        Pair<String, Integer> renderedTextDetails = this.getRenderedText(this.getMaxTextWidth());
        String renderedText = renderedTextDetails.a();
        int renderedTextStart = renderedTextDetails.b();
        Pair<Integer, Integer> highlightedVisibleInterval = this.getRenderedHighlighedInterval(renderedText);
        int startIndex = highlightedVisibleInterval.a();
        int endIndex = highlightedVisibleInterval.b();
        String firstPortion = renderedText.substring(0, startIndex);
        String highlightedPortion = renderedText.substring(startIndex, endIndex);
        String lastPortion = renderedText.substring(endIndex);
        Font font = FontRenderer.getInstance().getFont();
        int firstWidth = font.width(firstPortion);
        int highlightedWidth = font.width(highlightedPortion);
        int lastWidth = font.width(lastPortion);
        this.doRenderWidget(poseStack, renderedText, renderedTextStart, firstPortion, highlightedPortion, lastPortion, font, firstWidth, highlightedWidth, lastWidth);
    }

    protected void doRenderWidget(PoseStack poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, Font font, int firstWidth, int highlightedWidth, int lastWidth) {
        poseStack.pushPose();
        poseStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, 0.0f, 0.0f, 0.0f, this.width, this.height);
        RenderUtils.drawRectBorders(poseStack, this.isHovered ? CommonColors.LIGHT_GRAY : CommonColors.GRAY, 0.0f, 0.0f, this.width, this.height, 1.0f, 2.0f);
        boolean defaultText = Objects.equals(this.textBoxInput, "");
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(defaultText ? DEFAULT_TEXT.getString() : firstPortion), this.textPadding, this.width - lastWidth - highlightedWidth, this.textPadding, this.height - this.textPadding, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : this.renderColor, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (!defaultText) {
            FontRenderer.getInstance().renderAlignedHighlightedTextInBox(poseStack, StyledText.fromString(highlightedPortion), this.textPadding + firstWidth, this.width - lastWidth, this.textPadding, this.height - this.textPadding, 0.0f, CommonColors.BLUE, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(lastPortion), this.textPadding + firstWidth + highlightedWidth, this.width, this.textPadding, this.height - this.textPadding, 0.0f, this.renderColor, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        this.drawCursor(poseStack, font.width(renderedText.substring(0, Math.min(this.cursorPosition, renderedText.length()))), (this.textPadding + this.height - this.textPadding) / 2, VerticalAlignment.MIDDLE, false);
        if (this.isHovered && this.tooltip != null) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(this.tooltip, Component::getVisualOrderText));
        }
        poseStack.popPose();
    }

    protected int getMaxTextWidth() {
        return this.width - 8;
    }

    private Pair<String, Integer> getRenderedText(float maxTextWidth) {
        Font font = FontRenderer.getInstance().getFont();
        if ((float)font.width(this.textBoxInput) < maxTextWidth) {
            return Pair.of(this.textBoxInput, 0);
        }
        StringBuilder builder = new StringBuilder();
        int stringPosition = this.cursorPosition;
        while ((float)font.width(builder.toString()) < maxTextWidth && stringPosition > 0) {
            builder.append(this.textBoxInput.charAt(--stringPosition));
        }
        int startingAt = stringPosition;
        builder.reverse();
        for (stringPosition = this.cursorPosition; (float)font.width(builder.toString()) < maxTextWidth && stringPosition < this.textBoxInput.length(); ++stringPosition) {
            builder.append(this.textBoxInput.charAt(stringPosition));
        }
        return Pair.of(builder.toString(), startingAt);
    }

    private Pair<Integer, Integer> getRenderedHighlighedInterval(String renderedText) {
        if (renderedText.isEmpty()) {
            return Pair.of(0, 0);
        }
        int length = renderedText.length();
        int highlightedStart = Math.min(this.cursorPosition, this.highlightPosition);
        int highlightedEnd = Math.max(this.cursorPosition, this.highlightPosition);
        Pair<Integer, Integer> renderedInterval = Pair.of(0, length);
        Pair<Integer, Integer> highlightedInterval = Pair.of(highlightedStart, highlightedEnd);
        int a = 0;
        int b = 0;
        if (highlightedInterval.a() <= renderedInterval.b() && renderedInterval.a() <= highlightedInterval.b()) {
            a = Math.max(renderedInterval.a(), highlightedInterval.a());
            b = Math.min(renderedInterval.b(), highlightedInterval.b());
        }
        a = Mth.clamp((int)a, (int)0, (int)length);
        b = Mth.clamp((int)b, (int)0, (int)length);
        return Pair.of(a, b);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovered) {
            McUtils.playSoundUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
            if (button == 1) {
                this.setTextBoxInput("");
                this.setCursorAndHighlightPositions(0);
            } else {
                this.setCursorAndHighlightPositions(this.getIndexAtPosition(mouseX));
            }
            this.isDragging = true;
            this.textboxScreen.setFocusedTextInput(this);
            this.setFocused(true);
            return true;
        }
        if (this.isFocused()) {
            McUtils.playSoundUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
            this.setCursorAndHighlightPositions(this.cursorPosition);
            this.setFocused(false);
            this.textboxScreen.setFocusedTextInput(null);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.setCursorPosition(this.getIndexAtPosition(mouseX));
        }
        return true;
    }

    protected int getIndexAtPosition(double mouseX) {
        float width;
        double distance;
        mouseX -= (double)this.getX();
        mouseX -= (double)this.textPadding;
        Pair<String, Integer> renderedTextDetails = this.getRenderedText(this.getMaxTextWidth());
        String renderedText = renderedTextDetails.a();
        int shift = renderedTextDetails.b();
        Font font = FontRenderer.getInstance().getFont();
        if ((double)font.width(renderedText) < mouseX) {
            return renderedText.length() + shift;
        }
        int closestWidthCharIndex = 0;
        double closestDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < renderedText.length() && !((distance = Math.abs(mouseX - (double)(width = (float)font.width(renderedText.substring(0, i))))) > closestDistance)) {
            closestDistance = distance;
            closestWidthCharIndex = i++;
        }
        return closestWidthCharIndex + shift;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.isFocused()) {
            return false;
        }
        if (this.textBoxInput == null) {
            this.textBoxInput = "";
        }
        if (this.hasHighlighted()) {
            this.replaceHighlighted(String.valueOf(codePoint));
        } else {
            this.textBoxInput = this.textBoxInput.substring(0, this.cursorPosition) + codePoint + this.textBoxInput.substring(this.cursorPosition);
            this.setCursorPosition(this.cursorPosition + 1);
            this.setHighlightPosition(this.cursorPosition);
        }
        this.onUpdateConsumer.accept(this.getTextBoxInput());
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.removeFocus();
            return true;
        }
        KeyboardHandler keyboardHandler = Minecraft.getInstance().keyboardHandler;
        if (Screen.isCopy((int)keyCode)) {
            keyboardHandler.setClipboard(this.hasHighlighted() ? this.getHighlightedText() : this.getTextBoxInput());
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            if (this.hasHighlighted()) {
                this.replaceHighlighted(keyboardHandler.getClipboard());
            } else {
                this.setTextBoxInput(this.textBoxInput.substring(0, this.cursorPosition) + keyboardHandler.getClipboard() + this.textBoxInput.substring(this.cursorPosition));
            }
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            if (this.hasHighlighted()) {
                keyboardHandler.setClipboard(this.getHighlightedText());
                this.replaceHighlighted("");
            } else {
                keyboardHandler.setClipboard(this.getTextBoxInput());
                this.setTextBoxInput("");
            }
            return true;
        }
        if (Screen.isSelectAll((int)keyCode)) {
            this.setCursorPosition(this.textBoxInput.length());
            this.setHighlightPosition(0);
            return true;
        }
        if (keyCode == 259) {
            if (this.textBoxInput.isEmpty()) {
                return true;
            }
            if (this.hasHighlighted()) {
                this.replaceHighlighted("");
                return true;
            }
            if (Screen.hasControlDown()) {
                this.setTextBoxInput(this.textBoxInput.substring(this.cursorPosition));
                this.setCursorAndHighlightPositions(0);
                return true;
            }
            this.textBoxInput = this.textBoxInput.substring(0, Math.max(0, this.cursorPosition - 1)) + this.textBoxInput.substring(this.cursorPosition);
            this.setCursorAndHighlightPositions(this.cursorPosition - 1);
            this.onUpdateConsumer.accept(this.getTextBoxInput());
            return true;
        }
        if (keyCode == 261) {
            if (this.textBoxInput.isEmpty()) {
                return true;
            }
            if (this.hasHighlighted()) {
                this.replaceHighlighted("");
                return true;
            }
            if (Screen.hasControlDown()) {
                this.setTextBoxInput(this.textBoxInput.substring(0, this.cursorPosition));
                return true;
            }
            this.textBoxInput = this.textBoxInput.substring(0, this.cursorPosition) + this.textBoxInput.substring(Math.min(this.textBoxInput.length(), this.cursorPosition + 1));
            this.onUpdateConsumer.accept(this.getTextBoxInput());
            return true;
        }
        if (keyCode == 263) {
            if (this.hasHighlighted() && !Screen.hasShiftDown() && !Screen.hasControlDown()) {
                this.setCursorAndHighlightPositions(Math.min(this.cursorPosition, this.highlightPosition));
                return true;
            }
            if (Screen.hasControlDown() && Screen.hasShiftDown()) {
                this.setCursorPosition(0);
                return true;
            }
            if (Screen.hasControlDown()) {
                this.setCursorAndHighlightPositions(0);
                return true;
            }
            if (Screen.hasShiftDown()) {
                this.setCursorPosition(this.cursorPosition - 1);
                return true;
            }
            if (this.hasHighlighted()) {
                this.setCursorAndHighlightPositions(Math.min(this.cursorPosition, this.highlightPosition));
                return true;
            }
            this.setCursorAndHighlightPositions(this.cursorPosition - 1);
            return true;
        }
        if (keyCode == 262) {
            if (Screen.hasControlDown() && Screen.hasShiftDown()) {
                this.setCursorPosition(this.textBoxInput.length());
                return true;
            }
            if (Screen.hasControlDown()) {
                this.setCursorAndHighlightPositions(this.textBoxInput.length());
                return true;
            }
            if (Screen.hasShiftDown()) {
                this.setCursorPosition(this.cursorPosition + 1);
                return true;
            }
            if (this.hasHighlighted()) {
                this.setCursorAndHighlightPositions(Math.max(this.cursorPosition, this.highlightPosition));
                return true;
            }
            this.setCursorAndHighlightPositions(this.cursorPosition + 1);
            return true;
        }
        if (keyCode == 268) {
            this.setCursorAndHighlightPositions(0);
            return true;
        }
        if (keyCode == 269) {
            this.setCursorAndHighlightPositions(this.textBoxInput.length());
            return true;
        }
        return true;
    }

    public boolean isFocused() {
        return this.textboxScreen.getFocusedTextInput() == this;
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setTextBoxInput(String textBoxInput) {
        this.textBoxInput = textBoxInput;
        this.setCursorAndHighlightPositions(textBoxInput.length());
        this.onUpdateConsumer.accept(this.textBoxInput);
    }

    public void resetTextBoxInput() {
        this.textBoxInput = "";
        this.setCursorAndHighlightPositions(0);
    }

    protected void drawCursor(PoseStack poseStack, float x, float y, VerticalAlignment verticalAlignment, boolean forceUnfocusedCursor) {
        if (this.isDragging || this.hasHighlighted()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastCursorSwitch > 350L) {
            this.renderCursor = !this.renderCursor;
            this.lastCursorSwitch = System.currentTimeMillis();
        }
        if (!this.renderCursor) {
            return;
        }
        if (this.isFocused() || forceUnfocusedCursor) {
            Font font = FontRenderer.getInstance().getFont();
            float cursorRenderY = switch (verticalAlignment) {
                default -> throw new MatchException(null, null);
                case VerticalAlignment.TOP -> y - 2.0f;
                case VerticalAlignment.MIDDLE -> {
                    Objects.requireNonNull(font);
                    yield y - 9.0f + 2.0f;
                }
                case VerticalAlignment.BOTTOM -> {
                    Objects.requireNonNull(font);
                    yield y - 9.0f - 2.0f;
                }
            };
            Objects.requireNonNull(font);
            RenderUtils.drawRect(poseStack, CommonColors.WHITE, x + 1.0f, cursorRenderY, 0.0f, 1.0f, 9 + 3);
        }
    }

    protected void removeFocus() {
        this.textboxScreen.setFocusedTextInput(null);
    }

    protected void setCursorPosition(int cursorPosition) {
        this.cursorPosition = MathUtils.clamp(cursorPosition, 0, this.textBoxInput.length());
    }

    protected void setCursorAndHighlightPositions(int pos) {
        this.highlightPosition = this.cursorPosition = MathUtils.clamp(pos, 0, this.textBoxInput.length());
    }

    public String getTextBoxInput() {
        return this.textBoxInput;
    }

    private String getHighlightedText() {
        int startIndex = Math.min(this.cursorPosition, this.highlightPosition);
        int endIndex = Math.max(this.cursorPosition, this.highlightPosition);
        return this.textBoxInput.substring(startIndex, endIndex);
    }

    public void setRenderColor(CustomColor renderColor) {
        this.renderColor = renderColor;
    }

    private boolean hasHighlighted() {
        return this.cursorPosition != this.highlightPosition;
    }

    protected void setHighlightPosition(int position) {
        int length = this.textBoxInput.length();
        this.highlightPosition = Mth.clamp((int)position, (int)0, (int)length);
    }

    private void replaceHighlighted(String text) {
        int startIndex = Math.min(this.cursorPosition, this.highlightPosition);
        int endIndex = Math.max(this.cursorPosition, this.highlightPosition);
        int insertLength = text.length();
        this.textBoxInput = new StringBuilder(this.textBoxInput).replace(startIndex, endIndex, text).toString();
        this.setCursorPosition(startIndex + insertLength);
        this.setHighlightPosition(this.cursorPosition);
        this.onUpdateConsumer.accept(this.textBoxInput);
    }

    protected void onUpdate(String text) {
    }
}

