/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.chattabs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.TextWidget;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.chattabs.widgets.ChatTabsWidget;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ChatTabEditingScreen
extends WynntilsGridLayoutScreen {
    private static final int HEADER_ROW_Y = 6;
    private static final int FIRST_ROW_Y = 11;
    private static final int SECOND_ROW_Y = 22;
    private static final int THIRD_ROW_Y = 40;
    private static final int FOURTH_ROW_Y = 47;
    private static final int FIFTH_ROW_Y = 54;
    private List<AbstractWidget> chatTabsWidgets = new ArrayList<AbstractWidget>();
    private TextInputBoxWidget nameInput;
    private TextInputBoxWidget autoCommandInput;
    private TextInputBoxWidget orderInput;
    private final List<WynntilsCheckbox> recipientTypeBoxes = new ArrayList<WynntilsCheckbox>();
    private TextInputBoxWidget filterRegexInput;
    private TextWidget regexErrorMsg;
    private WynntilsCheckbox consumingCheckbox;
    private Button saveButton;
    private Button saveAndCloseButton;
    private boolean firstSetup;
    private final ChatTab edited;

    private ChatTabEditingScreen() {
        this((ChatTab)null);
    }

    private ChatTabEditingScreen(ChatTab tab) {
        super((Component)Component.literal((String)"Chat Tab Editing Screen"));
        this.edited = tab;
        this.firstSetup = true;
    }

    public static Screen create() {
        return new ChatTabEditingScreen();
    }

    public static Screen create(ChatTab chatTab) {
        return new ChatTabEditingScreen(chatTab);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.reloadChatTabsWidgets();
        this.nameInput = new TextInputBoxWidget((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 10.0f), 20, s -> this.updateSaveButtonActive(), this, this.nameInput);
        this.addRenderableWidget((GuiEventListener)this.nameInput);
        if (this.firstSetup) {
            if (this.edited != null) {
                this.nameInput.setTextBoxInput(this.edited.name());
            }
            this.setFocusedTextInput(this.nameInput);
        }
        this.autoCommandInput = new TextInputBoxWidget((int)(this.dividedWidth * 47.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 10.0f), 20, null, this, this.autoCommandInput);
        this.addRenderableWidget((GuiEventListener)this.autoCommandInput);
        if (this.firstSetup && this.edited != null && this.edited.autoCommand() != null) {
            this.autoCommandInput.setTextBoxInput(this.edited.autoCommand());
        }
        this.orderInput = new TextInputBoxWidget((int)(this.dividedWidth * 59.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 2.0f), 20, s -> this.updateSaveButtonActive(), this, this.orderInput);
        this.addRenderableWidget((GuiEventListener)this.orderInput);
        if (this.firstSetup && this.edited != null) {
            this.orderInput.setTextBoxInput(Integer.toString(Services.ChatTab.getTabIndex(this.edited)));
        }
        ArrayList<WynntilsCheckbox> oldBoxes = new ArrayList<WynntilsCheckbox>(this.recipientTypeBoxes);
        this.recipientTypeBoxes.clear();
        int x = (int)(this.dividedWidth * 35.0f);
        int y = (int)(this.dividedHeight * 22.0f);
        for (int i = 0; i < RecipientType.values().length; ++i) {
            if (i == 4 || i == 8) {
                y += (int)(this.dividedHeight * 5.0f);
                x = (int)(this.dividedWidth * 35.0f);
            }
            RecipientType type = RecipientType.values()[i];
            WynntilsCheckbox oldCheckbox = oldBoxes.stream().filter(checkbox -> checkbox.getMessage().getString().equals(type.getName())).findFirst().orElse(null);
            boolean oldCheckboxSelected = oldCheckbox != null && oldCheckbox.isSelected();
            boolean editedFirstSetupSelected = this.firstSetup && this.edited != null && (this.edited.filteredTypes() == null || this.edited.filteredTypes().contains((Object)type));
            boolean ticked = oldCheckboxSelected || editedFirstSetupSelected;
            WynntilsCheckbox newBox = new WynntilsCheckbox(x, y, 20, (Component)Component.literal((String)type.getName()), ticked, (int)(this.dividedWidth * 7.0f) - 24);
            this.addRenderableWidget((GuiEventListener)newBox);
            this.recipientTypeBoxes.add(newBox);
            x += (int)(this.dividedWidth * 7.0f);
        }
        this.filterRegexInput = new TextInputBoxWidget((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 40.0f), (int)(this.dividedWidth * 26.0f), 20, s -> this.updateSaveButtonActive(), this, this.filterRegexInput);
        this.addRenderableWidget((GuiEventListener)this.filterRegexInput);
        if (this.firstSetup && this.edited != null && this.edited.customRegexString() != null) {
            this.filterRegexInput.setTextBoxInput(this.edited.customRegexString());
        }
        this.regexErrorMsg = new TextWidget(this.width / 2 - 160 + 100, this.height / 2 + 75 + 7, 200, 20, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.regexErrorMsg);
        this.consumingCheckbox = new WynntilsCheckbox((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 47.0f), 20, (Component)Component.translatable((String)"screens.wynntils.chatTabsGui.consuming"), this.consumingCheckbox != null && this.consumingCheckbox.isSelected(), (int)(this.dividedWidth * 15.0f));
        this.addRenderableWidget((GuiEventListener)this.consumingCheckbox);
        if (this.firstSetup && this.edited != null) {
            this.consumingCheckbox.selected = this.edited.consuming();
        }
        String saveButtonKey = this.edited == null ? "screens.wynntils.chatTabsGui.add" : "screens.wynntils.chatTabsGui.save";
        this.saveButton = new Button.Builder((Component)Component.translatable((String)saveButtonKey).withStyle(ChatFormatting.GREEN), button -> {
            this.saveChatTab();
            this.reloadChatTabsWidgets();
        }).pos((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 54.0f)).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        String saveAndCloseButtonKey = this.edited == null ? "screens.wynntils.chatTabsGui.addAndClose" : "screens.wynntils.chatTabsGui.saveAndClose";
        this.saveAndCloseButton = new Button.Builder((Component)Component.translatable((String)saveAndCloseButtonKey).withStyle(ChatFormatting.GREEN), button -> {
            this.saveChatTab();
            this.onClose();
        }).pos((int)(this.dividedWidth * 44.0f), (int)(this.dividedHeight * 54.0f)).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveAndCloseButton);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.chatTabsGui.cancel"), button -> this.onClose()).pos((int)(this.dividedWidth * 53.0f), (int)(this.dividedHeight * 54.0f)).size((int)(this.dividedWidth * 8.0f), 20).build());
        this.firstSetup = false;
        this.updateSaveButtonActive();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        this.chatTabsWidgets.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
        if (this.edited == null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.create", (Object[])new Object[0])), this.dividedWidth * 48.0f, this.dividedHeight * 6.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        } else {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.edit", (Object[])new Object[]{this.edited.name()})), this.dividedWidth * 48.0f, this.dividedHeight * 6.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.name", (Object[])new Object[0]) + String.valueOf(ChatFormatting.DARK_RED) + " *"), (int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 11.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.autoCommand", (Object[])new Object[0])), (int)(this.dividedWidth * 47.0f), (int)(this.dividedHeight * 11.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.order", (Object[])new Object[0])), (int)(this.dividedWidth * 59.0f), (int)(this.dividedHeight * 11.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.types", (Object[])new Object[0]) + String.valueOf(ChatFormatting.DARK_RED) + " *"), (int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 21.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.chatTabsGui.filter", (Object[])new Object[0])), (int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 40.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractWidget widget : this.chatTabsWidgets) {
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            return widget.mouseClicked(mouseX, mouseY, button);
        }
        if (this.saveButton.isMouseOver(mouseX, mouseY)) {
            return this.saveButton.mouseClicked(mouseX, mouseY, button);
        }
        if (this.saveAndCloseButton.isMouseOver(mouseX, mouseY)) {
            return this.saveAndCloseButton.mouseClicked(mouseX, mouseY, button);
        }
        boolean mouseClicked = super.doMouseClicked(mouseX, mouseY, button);
        this.updateSaveButtonActive();
        return mouseClicked;
    }

    public void onClose() {
        McUtils.mc().setScreen((Screen)new ChatScreen(""));
    }

    private void saveChatTab() {
        if (this.edited != null) {
            Services.ChatTab.removeTab(this.edited);
        }
        int insertIndex = this.orderInput.getTextBoxInput().isEmpty() ? Services.ChatTab.getTabCount() : Math.min(Services.ChatTab.getTabCount(), Integer.parseInt(this.orderInput.getTextBoxInput()));
        ChatTab chatTab = new ChatTab(this.nameInput.getTextBoxInput(), this.consumingCheckbox.isSelected(), this.autoCommandInput.getTextBoxInput(), this.recipientTypeBoxes.stream().filter(WynntilsCheckbox::isSelected).map(box -> RecipientType.fromName(box.getMessage().getString())).collect(Collectors.toSet()), this.filterRegexInput.getTextBoxInput().isBlank() ? null : this.filterRegexInput.getTextBoxInput());
        Services.ChatTab.addTab(insertIndex, chatTab);
        McUtils.mc().setScreen(ChatTabEditingScreen.create(chatTab));
    }

    private void updateSaveButtonActive() {
        if (this.orderInput != null && !this.orderInput.getTextBoxInput().isBlank()) {
            try {
                Integer.parseInt(this.orderInput.getTextBoxInput());
                this.orderInput.setRenderColor(CommonColors.GREEN);
            }
            catch (NumberFormatException ignored) {
                this.orderInput.setRenderColor(CommonColors.RED);
                this.saveButton.active = false;
                this.saveAndCloseButton.active = false;
            }
        }
        if (this.saveButton == null || this.saveAndCloseButton == null) {
            return;
        }
        this.saveAndCloseButton.active = this.saveButton.active = !this.nameInput.getTextBoxInput().isEmpty() && this.validatePattern() && this.recipientTypeBoxes.stream().anyMatch(WynntilsCheckbox::isSelected);
    }

    private boolean validatePattern() {
        try {
            Pattern.compile(this.filterRegexInput.getTextBoxInput());
            this.regexErrorMsg.setMessage((Component)Component.empty());
        }
        catch (PatternSyntaxException e) {
            MutableComponent errorMessage = Component.literal((String)e.getDescription()).withStyle(ChatFormatting.RED).append((Component)Component.literal((String)(" (at pos " + e.getIndex() + ")")).withStyle(ChatFormatting.DARK_RED));
            this.regexErrorMsg.setMessage((Component)errorMessage);
            return false;
        }
        return true;
    }

    public boolean isActiveChatTab(ChatTab chatTab) {
        return this.edited != null && this.edited.equals(chatTab);
    }

    public void reloadChatTabsWidgets() {
        this.chatTabsWidgets = new ArrayList<AbstractWidget>();
        List<ChatTab> chatTabs = Services.ChatTab.getChatTabs();
        int initialVerticalOffset = (int)(this.dividedHeight * 32.0f) - (int)((this.dividedHeight * (float)(chatTabs.size() * 5 + 1) + 20.0f) / 2.0f);
        for (int i = 0; i < chatTabs.size(); ++i) {
            this.chatTabsWidgets.add(new ChatTabsWidget(this.dividedWidth * 3.0f, (float)initialVerticalOffset + this.dividedHeight * (float)(i * 5), (int)(this.dividedWidth * 29.0f) - (int)(this.dividedWidth * 3.0f), (int)(this.dividedHeight * 4.0f), chatTabs.get(i), 26.0f, this));
        }
        ChatFormatting color = this.edited == null ? ChatFormatting.GREEN : ChatFormatting.WHITE;
        this.chatTabsWidgets.add((AbstractWidget)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.chatTabsGui.new").withStyle(color), button -> McUtils.mc().setScreen(ChatTabEditingScreen.create())).pos((int)(this.dividedWidth * 13.0f), initialVerticalOffset + (int)(this.dividedHeight * (float)(chatTabs.size() * 5 + 1))).size((int)(this.dividedWidth * 6.0f), 20).build());
    }
}

