/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.chattabs;

import com.wynntils.core.components.Services;
import com.wynntils.screens.chattabs.widgets.ChatTabButton;
import com.wynntils.screens.chattabs.widgets.ChatTabSettingsButton;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.utils.mc.KeyboardUtils;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;

public class ChatTabsScreen
extends ChatScreen {
    private final boolean oldTabHotkey;

    public ChatTabsScreen(String initial, boolean oldTabHotkey) {
        super(initial);
        this.oldTabHotkey = oldTabHotkey;
    }

    public void init() {
        super.init();
        int xOffset = 0;
        this.addRenderableWidget((GuiEventListener)new ChatTabSettingsButton(xOffset + 2, this.height - 35, 12, 13));
        xOffset += 15;
        for (ChatTab chatTab : Services.ChatTab.getChatTabs()) {
            this.addRenderableWidget((GuiEventListener)new ChatTabButton(xOffset + 2, this.height - 35, 40, 13, chatTab));
            xOffset += 43;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            int newTab = -1;
            if (this.oldTabHotkey) {
                if (KeyboardUtils.isShiftDown()) {
                    newTab = Services.ChatTab.getTabIndexAfterFocused();
                }
            } else if (KeyboardUtils.isControlDown()) {
                int n = newTab = KeyboardUtils.isShiftDown() ? Services.ChatTab.getTabIndexBeforeFocused() : Services.ChatTab.getTabIndexAfterFocused();
            }
            if (newTab != -1) {
                Services.ChatTab.setFocusedTab(newTab);
                return true;
            }
        }
        if (KeyboardUtils.isControlDown() && keyCode >= 49 && keyCode <= 57) {
            ChatTab newTab = Services.ChatTab.getTab(keyCode - 49);
            if (newTab != null) {
                Services.ChatTab.setFocusedTab(newTab);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void changeFocus(ComponentPath componentPath) {
        GuiEventListener guiEventListener;
        if (componentPath instanceof ComponentPath.Path) {
            ComponentPath.Path path = (ComponentPath.Path)componentPath;
            v0 = path.childPath().component();
        } else {
            v0 = guiEventListener = componentPath.component();
        }
        if (guiEventListener instanceof ChatTabButton || guiEventListener instanceof ChatTabSettingsButton) {
            return;
        }
        super.changeFocus(componentPath);
    }
}

