/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.colorpicker.widgets;

import com.wynntils.screens.colorpicker.ColorPickerScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class AlphaSlider
extends AbstractSliderButton {
    private final ColorPickerScreen colorPickerScreen;

    public AlphaSlider(int x, int y, int width, int height, double value, ColorPickerScreen colorPickerScreen) {
        super(x, y, width, height, (Component)Component.literal((String)""), value);
        this.colorPickerScreen = colorPickerScreen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.fillSidewaysGradient(guiGraphics.pose(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0, CommonColors.WHITE.withAlpha(0), this.colorPickerScreen.getColor().withAlpha(255));
        double exactX = (double)this.getX() + (double)this.width * this.value;
        int handleX = (int)Math.round(exactX);
        RenderUtils.drawRectBorders(guiGraphics.pose(), CommonColors.DARK_GRAY, (float)((double)handleX - 1.0), this.getY(), (float)((double)handleX + 1.0), this.getY() + this.getHeight(), 2.0f, 1.0f);
    }

    public void onClick(double mouseX, double mouseY) {
        this.updateValue(mouseX);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.updateValue(mouseX);
    }

    protected void updateMessage() {
    }

    protected void applyValue() {
    }

    private void updateValue(double mouseX) {
        int newAlpha = (int)((mouseX - (double)this.getX()) / (double)this.getWidth() * 255.0);
        this.colorPickerScreen.setAlpha(Mth.clamp((int)newAlpha, (int)0, (int)255));
        this.setValue((mouseX - ((double)this.getX() + 0.5)) / (double)(this.width - 1));
    }
}

