/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.container.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.container.widgets.PersonalStorageUtilitiesWidget;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class PersonalStorageEditNameButton
extends WynntilsButton {
    private static final List<Component> CANCEL_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.containers.cancel.name").withStyle(ChatFormatting.RED), Component.translatable((String)"screens.wynntils.containers.cancel.description").withStyle(ChatFormatting.GRAY));
    private static final List<Component> EDIT_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.containers.edit.name").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"screens.wynntils.containers.edit.description").withStyle(ChatFormatting.GRAY));
    private final PersonalStorageUtilitiesWidget parent;

    public PersonalStorageEditNameButton(int x, int y, int width, int height, PersonalStorageUtilitiesWidget parent) {
        super(x, y, width, height, (Component)Component.literal((String)"Personal Storage Edit Name Button"));
        this.parent = parent;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.EDIT_NAME_ICON.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, Texture.EDIT_NAME_ICON.width(), Texture.EDIT_NAME_ICON.height());
        if (this.isHovered) {
            List<Component> tooltipToUse = Models.Bank.isEditingName() ? CANCEL_TOOLTIP : EDIT_TOOLTIP;
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(tooltipToUse, Component::getVisualOrderText));
        }
    }

    public void onPress() {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.parent.toggleEditInput(!Models.Bank.isEditingName());
        } else if (button == 1 && !Models.Bank.isEditingName()) {
            Models.Bank.resetCurrentPageName();
            this.parent.updatePageName();
        }
        return true;
    }
}

