/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.charm;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.charm.GuideCharmItemStack;
import com.wynntils.screens.guides.charm.GuideCharmItemStackButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.screens.guides.widgets.filters.RarityFilterWidget;
import com.wynntils.screens.guides.widgets.sorts.GuideSortButton;
import com.wynntils.services.itemfilter.statproviders.RarityStatProvider;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class WynntilsCharmGuideScreen
extends WynntilsGuideScreen<GuideCharmItemStack, GuideCharmItemStackButton> {
    private static final int ELEMENTS_COLUMNS = 7;
    private static final int ELEMENT_ROWS = 7;
    private List<GuideCharmItemStack> allCharmItems = List.of();

    private WynntilsCharmGuideScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.charmGuide.name"), List.of(ItemProviderType.GENERIC, ItemProviderType.GEAR, ItemProviderType.GEAR_INSTANCE));
    }

    public static Screen create() {
        return new WynntilsCharmGuideScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        SearchWidget searchWidget = this.searchWidget;
        if (searchWidget instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            this.guideFilterWidgets.add((GuideFilterWidget)this.addRenderableWidget((GuiEventListener)new RarityFilterWidget(19 + this.offsetX, 81 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideSortWidget.setSecondarySortButton(new GuideSortButton(itemSearchWidget.getSearchQuery(), this, RarityStatProvider.class));
        } else {
            WynntilsMod.error("WynntilsCharmGuideScreen's SearchWidget is not an ItemSearchWidget");
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, I18n.get((String)"screens.wynntils.wynntilsGuides.charmGuide.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderItemsHeader(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Renderable renderable = this.hovered;
        if (renderable instanceof GuideCharmItemStackButton) {
            GuideCharmItemStackButton guideCharmItemStackButton = (GuideCharmItemStackButton)renderable;
            guiGraphics.renderTooltip(FontRenderer.getInstance().getFont(), (ItemStack)guideCharmItemStackButton.getItemStack(), mouseX, mouseY);
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderItemsHeader(PoseStack poseStack) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.wynntilsGuides.itemGuide.available", (Object[])new Object[0])), (float)Texture.CONTENT_BOOK_BACKGROUND.width() * 0.75f + (float)this.offsetX, 30 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
    }

    @Override
    protected GuideCharmItemStackButton getButtonFromElement(int i) {
        int xOffset = i % 7 * 20;
        int yOffset = i % this.getElementsPerPage() / 7 * 20;
        return new GuideCharmItemStackButton((int)((float)xOffset + (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 13.0f + (float)this.offsetX), yOffset + 43 + this.offsetY, 18, 18, (GuideCharmItemStack)((Object)this.elements.get(i)), this);
    }

    @Override
    protected void reloadElementsList(ItemSearchQuery searchQuery) {
        this.elements.addAll(Services.ItemFilter.filterAndSort(searchQuery, this.getAllCharmItems()));
        this.guideFilterWidgets.forEach(filter -> filter.updateFromQuery(searchQuery));
        if (this.guideSortWidget == null) {
            return;
        }
        this.guideSortWidget.updateFromQuery(searchQuery);
    }

    private List<GuideCharmItemStack> getAllCharmItems() {
        if (this.allCharmItems.isEmpty()) {
            this.allCharmItems = Models.Rewards.getAllCharmInfos().map(GuideCharmItemStack::new).toList();
        }
        return this.allCharmItems;
    }

    @Override
    protected int getElementsPerPage() {
        return 49;
    }
}

