/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.sorts;

import com.wynntils.core.components.Services;
import com.wynntils.screens.guides.widgets.sorts.GuideSortButton;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.SortInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class GuideSortWidget
extends AbstractWidget {
    private GuideSortButton guideSortButtonPrimary;
    private GuideSortButton guideSortButtonSecondary;

    public GuideSortWidget(int x, int y) {
        super(x, y, 144, 16, (Component)Component.empty());
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.guideSortButtonPrimary.render(guiGraphics, mouseX, mouseY, partialTick);
        this.guideSortButtonSecondary.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.guideSortButtonPrimary.isMouseOver(mouseX, mouseY)) {
            return this.guideSortButtonPrimary.mouseClicked(mouseX, mouseY, button);
        }
        if (this.guideSortButtonSecondary.isMouseOver(mouseX, mouseY)) {
            return this.guideSortButtonSecondary.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void updateFromQuery(ItemSearchQuery searchQuery) {
        if (this.guideSortButtonPrimary == null || this.guideSortButtonSecondary == null) {
            return;
        }
        this.guideSortButtonPrimary.updateFromQuery(searchQuery);
        this.guideSortButtonSecondary.updateFromQuery(searchQuery);
    }

    public String getSortQuery() {
        return Services.ItemFilter.getItemFilterString(Map.of(), this.getSortInfos(), List.of());
    }

    public void setPrimarySortButton(GuideSortButton guideSortButton) {
        guideSortButton.setX(this.getX());
        guideSortButton.setY(this.getY());
        this.guideSortButtonPrimary = guideSortButton;
    }

    public void setSecondarySortButton(GuideSortButton guideSortButton) {
        guideSortButton.setX(this.getX() + 80);
        guideSortButton.setY(this.getY());
        this.guideSortButtonSecondary = guideSortButton;
    }

    private List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> sorts = new ArrayList<SortInfo>();
        SortInfo primarySortInfo = this.guideSortButtonPrimary.getSortInfo();
        SortInfo secondarySortInfo = this.guideSortButtonSecondary.getSortInfo();
        if (primarySortInfo != null) {
            sorts.add(primarySortInfo);
        }
        if (secondarySortInfo != null) {
            sorts.add(secondarySortInfo);
        }
        return sorts;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

