/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class PresetButton
extends BasicTexturedButton {
    private final int offsetX;
    private final int offsetY;
    private final StyledText message;

    public PresetButton(int x, int y, StyledText message, Consumer<Integer> onClick, List<Component> tooltip, int offsetX, int offsetY) {
        super(x, y, Texture.BUTTON_RIGHT.width(), Texture.BUTTON_RIGHT.height() / 2, Texture.BUTTON_RIGHT, onClick, tooltip);
        this.message = message;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (this.isHovered && MathUtils.isInside(mouseX, mouseY, this.offsetX, Texture.ITEM_FILTER_BACKGROUND.width(), this.offsetY, Texture.ITEM_FILTER_BACKGROUND.height())) {
            this.isHovered = false;
        }
        RenderUtils.drawHoverableTexturedRect(poseStack, Texture.BUTTON_RIGHT, this.getX(), this.getY(), this.isHovered);
        FontRenderer.getInstance().renderScrollingAlignedTextInBox(poseStack, this.message, this.getX() + 10, this.getX() + this.getWidth() - 8, this.getY() + 10, this.getY() + this.getHeight() - 10, this.getWidth() - 8, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL);
    }
}

