/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.services.itemfilter.filters.AnyStatFilters;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.services.itemfilter.type.StatValue;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ProviderButton
extends WynntilsButton {
    private static final CustomColor ENABLED_COLOR = new CustomColor(0, 220, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER = new CustomColor(0, 116, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER_HOVERED = new CustomColor(0, 66, 0, 255);
    private static final CustomColor DISABLED_COLOR = new CustomColor(255, 0, 0, 255);
    private static final CustomColor DISABLED_COLOR_BORDER = new CustomColor(120, 0, 0, 255);
    private static final CustomColor DISABLED_COLOR_BORDER_HOVERED = new CustomColor(70, 0, 0, 255);
    private static final Map<Class<?>, AnyStatFilters.AbstractAnyStatFilter> ANY_MAP = Map.of(String.class, new AnyStatFilters.AnyStringStatFilter(), Integer.class, new AnyStatFilters.AnyIntegerStatFilter(), CappedValue.class, new AnyStatFilters.AnyCappedValueStatFilter(), StatValue.class, new AnyStatFilters.AnyStatValueStatFilter());
    private final ItemFilterScreen filterScreen;
    private final ItemStatProvider<?> provider;
    private final List<Component> tooltip;

    public ProviderButton(int x, int y, int width, int height, ItemFilterScreen filterScreen, ItemStatProvider<?> provider) {
        super(x, y, width, height, (Component)Component.literal((String)provider.getTranslatedName()));
        this.filterScreen = filterScreen;
        this.provider = provider;
        this.tooltip = provider.getType().equals(Boolean.class) ? List.of(Component.literal((String)provider.getDescription()), Component.translatable((String)"screens.wynntils.itemFilter.providerHelp2")) : List.of(Component.literal((String)provider.getDescription()), Component.translatable((String)"screens.wynntils.itemFilter.providerHelp1"), Component.translatable((String)"screens.wynntils.itemFilter.providerHelp2"));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, this.getRectColor().withAlpha(100), this.getX(), this.getY(), 0.0f, this.width, this.height);
        RenderUtils.drawRectBorders(poseStack, this.getBorderColor(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 1.0f, 2.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.provider.getDisplayName()), this.getX() + 2, (float)this.getY() + (float)this.height / 2.0f, this.width - 4, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        if (this.isHovered && (mouseY <= this.filterScreen.getProviderMaskTopY() || mouseY >= this.filterScreen.getProviderMaskBottomY())) {
            this.isHovered = false;
        }
        if (this.isHovered) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(this.tooltip, Component::getVisualOrderText));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.filterScreen.getProviderMaskTopY() || mouseY >= (double)this.filterScreen.getProviderMaskBottomY()) {
            return false;
        }
        if (this.filterScreen.inSortMode()) {
            if (button == 0) {
                this.filterScreen.addSort(new SortInfo(SortDirection.ASCENDING, this.provider));
            } else if (button == 1) {
                this.filterScreen.removeSort(this.provider);
            }
        } else {
            AnyStatFilters.AbstractAnyStatFilter anyFilter;
            if (button == 0) {
                this.filterScreen.setSelectedProvider(this.provider);
            } else if (button == 1) {
                this.filterScreen.setFiltersForProvider(this.provider, null);
            } else if (button == 2 && (anyFilter = (AnyStatFilters.AbstractAnyStatFilter)ANY_MAP.getOrDefault(this.provider.getType(), null)) != null) {
                this.filterScreen.setFiltersForProvider(this.provider, List.of(new StatProviderAndFilterPair(this.provider, anyFilter)));
            }
            this.filterScreen.updateFilterWidget();
        }
        return true;
    }

    public void onPress() {
    }

    private CustomColor getRectColor() {
        ItemFilterScreen itemFilterScreen;
        Screen screen = McUtils.mc().screen;
        if (screen instanceof ItemFilterScreen && (itemFilterScreen = (ItemFilterScreen)screen).getSelectedProvider() == this.provider) {
            return CommonColors.GRAY;
        }
        return this.filterScreen.isProviderInUse(this.provider) ? ENABLED_COLOR : DISABLED_COLOR;
    }

    private CustomColor getBorderColor() {
        ItemFilterScreen itemFilterScreen;
        Screen screen = McUtils.mc().screen;
        if (screen instanceof ItemFilterScreen && (itemFilterScreen = (ItemFilterScreen)screen).getSelectedProvider() == this.provider) {
            return this.isHovered ? CommonColors.LIGHT_GRAY : CommonColors.WHITE;
        }
        return this.filterScreen.isProviderInUse(this.provider) ? (this.isHovered ? ENABLED_COLOR_BORDER_HOVERED : ENABLED_COLOR_BORDER) : (this.isHovered ? DISABLED_COLOR_BORDER_HOVERED : DISABLED_COLOR_BORDER);
    }
}

