/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemsharing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemsharing.SavedItemsScreen;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ErrorOr;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public final class ItemSharingScreen
extends WynntilsScreen {
    private final ItemStack itemStack;
    private final WynnItem wynnItem;
    private final Screen previousScreen;
    private boolean savedItem = false;
    private Button saveButton;
    private EncodedByteBuffer encodedItem;
    private int backgroundX;
    private int backgroundY;
    private int tooltipX;
    private ItemStack previewItemStack;
    private List<AbstractWidget> options = new ArrayList<AbstractWidget>();

    private ItemSharingScreen(WynnItem wynnItem, ItemStack itemStack) {
        super((Component)Component.literal((String)"Item Sharing Screen"));
        this.wynnItem = wynnItem;
        this.itemStack = itemStack;
        this.previousScreen = McUtils.mc().screen;
    }

    private ItemSharingScreen(WynnItem wynnItem, ItemStack itemStack, boolean savedItem) {
        super((Component)Component.literal((String)"Item Sharing Screen"));
        this.wynnItem = wynnItem;
        this.itemStack = itemStack;
        this.savedItem = savedItem;
        this.previousScreen = McUtils.mc().screen;
    }

    public static Screen create(WynnItem wynnItem, ItemStack itemStack) {
        return new ItemSharingScreen(wynnItem, itemStack);
    }

    public static Screen create(WynnItem wynnItem, ItemStack itemStack, boolean savedItem) {
        return new ItemSharingScreen(wynnItem, itemStack, savedItem);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.backgroundY = (this.height - Texture.ITEM_SHARING_BACKGROUND.height()) / 2;
        this.refreshPreview();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemSharing.sharingOptions").withStyle(ChatFormatting.BOLD)), this.backgroundX + 10, this.backgroundY + 10, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        this.renderPreview(guiGraphics);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(guiGraphics.pose(), Texture.ITEM_SHARING_BACKGROUND, this.backgroundX, this.backgroundY);
    }

    public void onClose() {
        McUtils.mc().setScreen(this.previousScreen);
    }

    private void renderPreview(GuiGraphics guiGraphics) {
        if (this.previewItemStack == null) {
            return;
        }
        Font font = FontRenderer.getInstance().getFont();
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        guiGraphics.renderTooltip(font, this.previewItemStack, this.tooltipX, this.backgroundY + 9 * 2);
    }

    private void refreshPreview() {
        String string;
        EncodingSettings encodingSettings = new EncodingSettings((Boolean)Models.ItemEncoding.extendedIdentificationEncoding.get(), (Boolean)Models.ItemEncoding.shareItemName.get());
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(this.wynnItem, encodingSettings);
        if (errorOrEncodedByteBuffer.hasError()) {
            WynntilsMod.error("Failed to encode item: " + errorOrEncodedByteBuffer.getError());
            this.previewItemStack = null;
            this.backgroundX = (this.width - Texture.ITEM_SHARING_BACKGROUND.width()) / 2;
            this.clearWidgets();
            this.addError(errorOrEncodedByteBuffer.getError());
            return;
        }
        this.encodedItem = errorOrEncodedByteBuffer.getValue();
        WynnItem wynnItem = this.wynnItem;
        if (wynnItem instanceof NamedItemProperty) {
            NamedItemProperty namedItem = (NamedItemProperty)((Object)wynnItem);
            string = namedItem.getName();
        } else {
            string = null;
        }
        String itemName = string;
        ErrorOr<WynnItem> errorOrDecodedByteBuffer = Models.ItemEncoding.decodeItem(this.encodedItem, itemName);
        if (errorOrDecodedByteBuffer.hasError()) {
            WynntilsMod.error("Failed to decode item: " + errorOrDecodedByteBuffer.getError());
            this.previewItemStack = null;
            this.backgroundX = (this.width - Texture.ITEM_SHARING_BACKGROUND.width()) / 2;
            this.clearWidgets();
            this.addError(errorOrDecodedByteBuffer.getError());
            return;
        }
        WynnItem renderedItem = errorOrDecodedByteBuffer.getValue();
        this.previewItemStack = new FakeItemStack(renderedItem, "From chat");
        int tooltipWidth = LoreUtils.getTooltipLines(this.previewItemStack).stream().map(component -> McUtils.mc().font.width((FormattedText)component)).max(Integer::compareTo).orElse(0);
        int totalRenderWidth = tooltipWidth + Texture.ITEM_SHARING_BACKGROUND.width() + 10;
        int sideGap = Math.abs((this.width - totalRenderWidth) / 2);
        this.tooltipX = this.width - sideGap - tooltipWidth - 20;
        this.backgroundX = Math.max(0, sideGap - 10);
        for (AbstractWidget widget : this.options) {
            this.removeWidget((GuiEventListener)widget);
        }
        this.options = new ArrayList<AbstractWidget>();
        this.addSharingOptions();
    }

    private void shareItem(String target) {
        switch (target) {
            case "guild": {
                Handlers.Command.sendCommandImmediately("g " + Models.ItemEncoding.makeItemString(this.wynnItem, this.encodedItem));
                break;
            }
            case "party": {
                Handlers.Command.sendCommandImmediately("p " + Models.ItemEncoding.makeItemString(this.wynnItem, this.encodedItem));
                break;
            }
            case "save": {
                ItemStack itemStackToSave = this.itemStack;
                WynnItem wynnItem = this.wynnItem;
                if (wynnItem instanceof GearItem) {
                    GearItem gearItem = (GearItem)wynnItem;
                    itemStackToSave = new FakeItemStack(gearItem, "From " + McUtils.playerName() + "'s Item Record");
                }
                this.savedItem = Services.ItemRecord.saveItem(this.wynnItem, itemStackToSave, this.itemStack.getHoverName());
                if (!this.savedItem) break;
                this.saveButton.setMessage((Component)Component.translatable((String)"screens.wynntils.itemSharing.openRecord"));
                break;
            }
            default: {
                McUtils.mc().keyboardHandler.setClipboard(Models.ItemEncoding.makeItemString(this.wynnItem, this.encodedItem));
                McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.itemSharing.copied").withStyle(ChatFormatting.GREEN));
            }
        }
    }

    private void addSharingOptions() {
        if (this.wynnItem instanceof IdentifiableItemProperty) {
            this.options.add((AbstractWidget)this.addRenderableWidget((GuiEventListener)new WynntilsCheckbox(this.backgroundX + 15, this.backgroundY + 25, 10, (Component)Component.translatable((String)"screens.wynntils.itemSharing.extended.name"), (Boolean)Models.ItemEncoding.extendedIdentificationEncoding.get(), Texture.ITEM_SHARING_BACKGROUND.width() - 30, (c, b) -> {
                Models.ItemEncoding.extendedIdentificationEncoding.store((Boolean)b);
                this.refreshPreview();
            }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.itemSharing.extended.description1"), Component.translatable((String)"screens.wynntils.itemSharing.extended.description2")), 150))));
        } else if (this.wynnItem instanceof CraftedGearItem || this.wynnItem instanceof CraftedConsumableItem) {
            this.options.add((AbstractWidget)this.addRenderableWidget((GuiEventListener)new WynntilsCheckbox(this.backgroundX + 15, this.backgroundY + 25, 10, (Component)Component.translatable((String)"screens.wynntils.itemSharing.itemName.name"), (Boolean)Models.ItemEncoding.shareItemName.get(), Texture.ITEM_SHARING_BACKGROUND.width() - 30, (c, b) -> {
                Models.ItemEncoding.shareItemName.store((Boolean)b);
                this.refreshPreview();
            }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.itemSharing.itemName.description")), 150))));
        }
        int shareButtonWidth = (Texture.ITEM_SHARING_BACKGROUND.width() - 20) / 2 - 5;
        this.options.add((AbstractWidget)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.itemSharing.shareParty"), b -> this.shareItem("party")).pos(this.backgroundX + 10, this.backgroundY + 45).size(shareButtonWidth, 20).build()));
        this.options.add((AbstractWidget)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.itemSharing.shareGuild"), b -> this.shareItem("guild")).pos(this.backgroundX + 20 + shareButtonWidth, this.backgroundY + 45).size(shareButtonWidth, 20).build()));
        MutableComponent saveButtonMessage = this.savedItem ? Component.translatable((String)"screens.wynntils.itemSharing.openRecord") : Component.translatable((String)"screens.wynntils.itemSharing.save");
        this.saveButton = new Button.Builder((Component)saveButtonMessage, b -> {
            if (!this.savedItem) {
                this.shareItem("save");
            } else {
                McUtils.mc().setScreen(SavedItemsScreen.create());
            }
        }).pos(this.backgroundX + 10, this.backgroundY + Texture.ITEM_SHARING_BACKGROUND.height() - 30).size(shareButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.options.add((AbstractWidget)this.saveButton);
        this.options.add((AbstractWidget)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.itemSharing.copy"), b -> this.shareItem("clipboard")).pos(this.backgroundX + 20 + shareButtonWidth, this.backgroundY + Texture.ITEM_SHARING_BACKGROUND.height() - 30).size(shareButtonWidth, 20).build()));
    }

    private void addError(String error) {
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.itemSharing.error"), b -> {}).pos(this.backgroundX + 10, this.backgroundY + Texture.ITEM_SHARING_BACKGROUND.height() - 30).size(Texture.ITEM_SHARING_BACKGROUND.width() - 20, 20).tooltip(Tooltip.create((Component)Component.literal((String)error))).build());
    }
}

