/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.GuildMapFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.territories.TerritoryInfo;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.maps.AbstractMapScreen;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.TerritoryPoi;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.services.map.type.TerritoryDefenseFilterType;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class GuildMapScreen
extends AbstractMapScreen {
    private boolean resourceMode = false;
    private boolean territoryDefenseFilterEnabled = false;
    private boolean hybridMode = true;
    private GuildResourceValues territoryDefenseFilterLevel = GuildResourceValues.VERY_HIGH;
    private TerritoryDefenseFilterType territoryDefenseFilterType = TerritoryDefenseFilterType.DEFAULT;
    private BasicTexturedButton territoryDefenseFilterButton;
    private BasicTexturedButton hybridModeButton;

    private GuildMapScreen() {
    }

    public static Screen create() {
        return new GuildMapScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 7 + 120, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 10, 16, Texture.HELP_ICON, b -> {}, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)"screens.wynntils.map.help.name")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.guildMap.help.description1")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.guildMap.help.description2")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.guildMap.help.description3")))));
        this.hybridModeButton = new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 4 + 40, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 16, 16, Texture.OVERLAY_EXTRA_ICON, b -> {
            this.hybridMode = !this.hybridMode;
            this.hybridModeButton.setTooltip(this.getHybridModeTooltip());
        }, this.getHybridModeTooltip());
        this.addRenderableWidget((GuiEventListener)this.hybridModeButton);
        this.territoryDefenseFilterButton = (BasicTexturedButton)this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 4 + 20, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 16, 16, Texture.DEFENSE_FILTER_ICON, b -> {
            if (b == 2) {
                this.territoryDefenseFilterEnabled = false;
                this.territoryDefenseFilterType = TerritoryDefenseFilterType.DEFAULT;
                this.territoryDefenseFilterButton.setTooltip(this.getCompleteFilterTooltip());
                return;
            }
            this.territoryDefenseFilterType = KeyboardUtils.isShiftDown() ? TerritoryDefenseFilterType.HIGHER : (KeyboardUtils.isControlDown() ? TerritoryDefenseFilterType.LOWER : TerritoryDefenseFilterType.DEFAULT);
            this.territoryDefenseFilterEnabled = true;
            if (b == 0) {
                this.territoryDefenseFilterLevel = this.territoryDefenseFilterLevel.getFilterNext(this.territoryDefenseFilterType != TerritoryDefenseFilterType.DEFAULT);
            } else if (b == 1) {
                this.territoryDefenseFilterLevel = this.territoryDefenseFilterLevel.getFilterPrevious(this.territoryDefenseFilterType != TerritoryDefenseFilterType.DEFAULT);
            }
            this.territoryDefenseFilterButton.setTooltip(this.getCompleteFilterTooltip());
        }, this.getCompleteFilterTooltip()));
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 14, 14, Texture.ADD_ICON, b -> {
            this.resourceMode = !this.resourceMode;
        }, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.guildMap.toggleResourceColor.name")), Component.translatable((String)"screens.wynntils.guildMap.toggleResourceColor.description").withStyle(ChatFormatting.GRAY))));
        if (this.firstInit) {
            if (!this.isPlayerInsideMainArea()) {
                this.centerMapOnWorld();
            }
            this.firstInit = false;
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (this.holdingMapKey && !Managers.Feature.getFeatureInstance(GuildMapFeature.class).openGuildMapKeybind.getKeyMapping().isDown()) {
            this.onClose();
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        this.renderMap(guiGraphics);
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        this.renderPois(poseStack, mouseX, mouseY);
        this.renderCursor(poseStack, 1.5f, (CustomColor)Managers.Feature.getFeatureInstance(GuildMapFeature.class).pointerColor.get(), (PointerType)((Object)Managers.Feature.getFeatureInstance(GuildMapFeature.class).pointerType.get()));
        RenderUtils.disableScissor(guiGraphics);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderCoordinates(poseStack, mouseX, mouseY);
        this.renderMapButtons(guiGraphics, mouseX, mouseY, partialTick);
        this.renderHoveredTerritoryInfo(poseStack);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderPois(List<Poi> pois, PoseStack poseStack, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        float poiRenderZ;
        float poiRenderX;
        this.hovered = null;
        List<Poi> filteredPois = this.getRenderedPois(pois, textureBoundingBox, poiScale, mouseX, mouseY);
        for (Poi poi : filteredPois) {
            if (!(poi instanceof TerritoryPoi)) continue;
            TerritoryPoi territoryPoi = (TerritoryPoi)poi;
            poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            for (String tradingRoute : territoryPoi.getTerritoryInfo().getTradingRoutes()) {
                Optional<Poi> routePoi = filteredPois.stream().filter(filteredPoi -> filteredPoi.getName().equals(tradingRoute)).findFirst();
                if (!routePoi.isPresent() || !filteredPois.contains(routePoi.get())) continue;
                float x = MapRenderer.getRenderX(routePoi.get(), this.mapCenterX, this.centerX, this.zoomRenderScale);
                float z = MapRenderer.getRenderZ(routePoi.get(), this.mapCenterZ, this.centerZ, this.zoomRenderScale);
                RenderUtils.drawLine(poseStack, CommonColors.DARK_GRAY, poiRenderX, poiRenderZ, x, z, 0.0f, 1.0f);
            }
        }
        MultiBufferSource.BufferSource bufferSource = McUtils.mc().renderBuffers().bufferSource();
        for (int i = filteredPois.size() - 1; i >= 0; --i) {
            Poi poi = filteredPois.get(i);
            poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            poi.renderAt(poseStack, (MultiBufferSource)bufferSource, poiRenderX, poiRenderZ, this.hovered == poi, poiScale, this.zoomRenderScale, this.zoomLevel, true);
        }
        bufferSource.endBatch();
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        Poi poi;
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY)) continue;
            child.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        if (button == 1 && KeyboardUtils.isShiftDown() && (poi = this.hovered) instanceof TerritoryPoi) {
            TerritoryPoi territoryPoi = (TerritoryPoi)poi;
            Handlers.Command.queueCommand("gu territory " + territoryPoi.getName());
        } else if (button == 0) {
            if (this.hovered instanceof WaypointPoi) {
                MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(this.hovered.getLocation().asLocation());
                return true;
            }
        } else if (button == 2) {
            this.setCompassToMouseCoords(mouseX, mouseY, !KeyboardUtils.isShiftDown());
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    private void renderHoveredTerritoryInfo(PoseStack poseStack) {
        Poi poi = this.hovered;
        if (!(poi instanceof TerritoryPoi)) {
            return;
        }
        TerritoryPoi territoryPoi = (TerritoryPoi)poi;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 101.0f);
        int xOffset = (int)((float)this.width - 10.0f - 250.0f);
        int yOffset = 50;
        if (territoryPoi.isFakeTerritoryInfo()) {
            GuildMapScreen.renderTerritoryTooltipWithFakeInfo(poseStack, xOffset, yOffset, territoryPoi);
        } else {
            GuildMapScreen.renderTerritoryTooltip(poseStack, xOffset, yOffset, territoryPoi);
        }
        poseStack.popPose();
    }

    private void renderPois(PoseStack poseStack, int mouseX, int mouseY) {
        List<TerritoryPoi> advancementPois = this.territoryDefenseFilterEnabled ? Models.Territory.getFilteredTerritoryPoisFromAdvancement(this.territoryDefenseFilterLevel.getLevel(), this.territoryDefenseFilterType) : Models.Territory.getTerritoryPoisFromAdvancement();
        ArrayList<Poi> renderedPois = new ArrayList<Poi>();
        if (this.hybridMode) {
            for (TerritoryPoi poi : advancementPois) {
                TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfile(poi.getName());
                if (territoryProfile != null && territoryProfile.getGuild().equals(poi.getTerritoryInfo().getGuildName())) {
                    renderedPois.add(poi);
                    continue;
                }
                renderedPois.add(new TerritoryPoi(territoryProfile, poi.getTerritoryInfo()));
            }
        } else {
            renderedPois.addAll(advancementPois);
        }
        MarkerModel.USER_WAYPOINTS_PROVIDER.getPois().forEach(renderedPois::add);
        this.renderPois(renderedPois, poseStack, BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.width / this.zoomRenderScale, (float)this.height / this.zoomRenderScale), 1.0f, mouseX, mouseY);
    }

    public boolean isResourceMode() {
        return this.resourceMode;
    }

    private static void renderTerritoryTooltip(PoseStack poseStack, int xOffset, int yOffset, TerritoryPoi territoryPoi) {
        TerritoryInfo territoryInfo = territoryPoi.getTerritoryInfo();
        TerritoryProfile territoryProfile = territoryPoi.getTerritoryProfile();
        int textureWidth = Texture.MAP_INFO_TOOLTIP_CENTER.width();
        float centerHeight = 75 + (territoryInfo.getStorage().size() + territoryInfo.getGenerators().size()) * 10 + (territoryInfo.isHeadquarters() ? 20 : 0);
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_TOOLTIP_TOP, xOffset, yOffset);
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_TOOLTIP_CENTER.resource(), xOffset, Texture.MAP_INFO_TOOLTIP_TOP.height() + yOffset, textureWidth, centerHeight, textureWidth, Texture.MAP_INFO_TOOLTIP_CENTER.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_NAME_BOX, xOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)yOffset);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("%s [%s]".formatted(territoryInfo.getGuildName(), territoryInfo.getGuildPrefix())), 10 + xOffset, 10 + yOffset, CommonColors.MAGENTA, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        float renderYOffset = 20 + yOffset;
        for (GuildResource value : GuildResource.values()) {
            int generation = territoryInfo.getGeneration(value);
            CappedValue storage = territoryInfo.getStorage(value);
            if (generation != 0) {
                StyledText formattedGenerated = StyledText.fromString("%s+%d %s per Hour".formatted(value.getPrettySymbol(), generation, value.getName()));
                FontRenderer.getInstance().renderText(poseStack, formattedGenerated, 10 + xOffset, 10.0f + renderYOffset, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
                renderYOffset += 10.0f;
            }
            if (storage == null) continue;
            StyledText formattedStored = StyledText.fromString("%s%d/%d %s stored".formatted(value.getPrettySymbol(), storage.current(), storage.max(), value.getName()));
            FontRenderer.getInstance().renderText(poseStack, formattedStored, 10 + xOffset, 10.0f + renderYOffset, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
            renderYOffset += 10.0f;
        }
        StyledText treasury = StyledText.fromString(String.valueOf(ChatFormatting.GRAY) + "\u2726 Treasury: %s".formatted(String.valueOf(territoryInfo.getTreasury().getTreasuryColor()) + territoryInfo.getTreasury().getAsString()));
        StyledText defences = StyledText.fromString(String.valueOf(ChatFormatting.GRAY) + "Territory Defences: %s".formatted(String.valueOf(territoryInfo.getDefences().getDefenceColor()) + territoryInfo.getDefences().getAsString()));
        FontRenderer.getInstance().renderText(poseStack, treasury, 10 + xOffset, 10.0f + (renderYOffset += 10.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderText(poseStack, defences, 10 + xOffset, 10.0f + (renderYOffset += 10.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        if (territoryInfo.isHeadquarters()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("Guild Headquarters"), 10 + xOffset, 10.0f + (renderYOffset += 20.0f), CommonColors.RED, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        }
        String timeHeldString = territoryProfile.getGuild().equals(territoryInfo.getGuildName()) ? String.valueOf(territoryProfile.getTimeAcquiredColor()) + territoryProfile.getReadableRelativeTimeAcquired() : "-";
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(ChatFormatting.GRAY) + "Time Held: " + timeHeldString), 10 + xOffset, 10.0f + (renderYOffset += 20.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(territoryPoi.getName()), 7 + xOffset, textureWidth + xOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)yOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)Texture.MAP_INFO_NAME_BOX.height() + (float)yOffset, 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
    }

    private static void renderTerritoryTooltipWithFakeInfo(PoseStack poseStack, int xOffset, int yOffset, TerritoryPoi territoryPoi) {
        TerritoryInfo territoryInfo = territoryPoi.getTerritoryInfo();
        TerritoryProfile territoryProfile = territoryPoi.getTerritoryProfile();
        int textureWidth = Texture.MAP_INFO_TOOLTIP_CENTER.width();
        float centerHeight = 35.0f;
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_TOOLTIP_TOP, xOffset, yOffset);
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_TOOLTIP_CENTER.resource(), xOffset, Texture.MAP_INFO_TOOLTIP_TOP.height() + yOffset, textureWidth, 35.0f, textureWidth, Texture.MAP_INFO_TOOLTIP_CENTER.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_NAME_BOX, xOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + 35.0f + (float)yOffset);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("%s [%s]".formatted(territoryProfile.getGuild(), territoryProfile.getGuildPrefix())), 10 + xOffset, 10 + yOffset, CommonColors.MAGENTA, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.guildMap.hybridMode.noAdvancementData")), 10 + xOffset, 30 + yOffset, CommonColors.LIGHT_GRAY, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(territoryPoi.getName()), 7 + xOffset, textureWidth + xOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + 35.0f + (float)yOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + 35.0f + (float)Texture.MAP_INFO_NAME_BOX.height() + (float)yOffset, 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
    }

    private List<Component> getCompleteFilterTooltip() {
        MutableComponent lastLine = this.territoryDefenseFilterEnabled ? Component.translatable((String)"screens.wynntils.guildMap.cycleDefenseFilter.description4").withStyle(ChatFormatting.GRAY).append(String.valueOf(this.territoryDefenseFilterLevel.getDefenceColor()) + this.territoryDefenseFilterLevel.getAsString()).append(this.territoryDefenseFilterType.asComponent()) : Component.translatable((String)"screens.wynntils.guildMap.cycleDefenseFilter.description4").withStyle(ChatFormatting.GRAY).append("Off");
        return List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.BLUE).append((Component)Component.translatable((String)"screens.wynntils.guildMap.cycleDefenseFilter.name")), Component.translatable((String)"screens.wynntils.guildMap.cycleDefenseFilter.description1").withStyle(ChatFormatting.GRAY), Component.translatable((String)"screens.wynntils.guildMap.cycleDefenseFilter.description2").withStyle(ChatFormatting.GRAY), Component.translatable((String)"screens.wynntils.guildMap.cycleDefenseFilter.description3").withStyle(ChatFormatting.GRAY), lastLine);
    }

    private List<Component> getHybridModeTooltip() {
        return List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"screens.wynntils.guildMap.hybridMode.name")), Component.translatable((String)"screens.wynntils.guildMap.hybridMode.description1").withStyle(ChatFormatting.GRAY), Component.translatable((String)"screens.wynntils.guildMap.hybridMode.description2").withStyle(ChatFormatting.GRAY).append((Component)(this.hybridMode ? Component.translatable((String)"screens.wynntils.guildMap.hybridMode.hybrid").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"screens.wynntils.guildMap.hybridMode.advancement").withStyle(ChatFormatting.RED))));
    }
}

