/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.features.debug.MappingProgressFeature;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.marker.type.DynamicLocationSupplier;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.maps.AbstractMapScreen;
import com.wynntils.screens.maps.PoiCreationScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.services.hades.type.PlayerRelation;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.services.map.pois.IconPoi;
import com.wynntils.services.map.pois.PlayerMainMapPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.TerritoryPoi;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.wynn.LocationUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public final class MainMapScreen
extends AbstractMapScreen {
    private MarkerInfo focusedMarker;
    private boolean showTerrs = false;

    private MainMapScreen() {
        this.centerMapAroundPlayer();
    }

    private MainMapScreen(float mapCenterX, float mapCenterZ) {
        super(mapCenterX, mapCenterZ);
        this.updateMapCenter(mapCenterX, mapCenterZ);
    }

    public static Screen create() {
        return new MainMapScreen();
    }

    public static Screen create(float mapCenterX, float mapCenterZ) {
        return new MainMapScreen(mapCenterX, mapCenterZ);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 7 + 120, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 10, 16, Texture.HELP_ICON, b -> {}, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)"screens.wynntils.map.help.name")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description1")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description2")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description3")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description4")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description5")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description6")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description7")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description8")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description9")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.help.description10")))));
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6 + 60, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 12, 16, Texture.WAYPOINT_MANAGER_ICON, b -> McUtils.mc().setScreen(PoiManagementScreen.create(this)), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"screens.wynntils.map.manager.name")), Component.translatable((String)"screens.wynntils.map.manager.description").withStyle(ChatFormatting.GRAY))));
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 4 + 40, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 16, 14, Texture.SHARE_ICON, this::shareLocationOrCompass, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.translatable((String)"screens.wynntils.map.share.name")), Component.translatable((String)"screens.wynntils.map.share.description1_1").withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)"screens.wynntils.map.share.description1_2").withStyle(ChatFormatting.GRAY)), Component.translatable((String)"screens.wynntils.map.share.description2_1").withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)"screens.wynntils.map.share.description2_2").withStyle(ChatFormatting.GRAY)), Component.translatable((String)"screens.wynntils.map.share.description3_1").withStyle(ChatFormatting.AQUA).append((Component)Component.translatable((String)"screens.wynntils.map.share.description3_2").withStyle(ChatFormatting.GRAY)))));
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6 + 20, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 12, 16, Texture.WAYPOINT_FOCUS_ICON, b -> {
            if (KeyboardUtils.isShiftDown()) {
                this.centerMapAroundPlayer();
                return;
            }
            List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
            if (!markers.isEmpty()) {
                MarkerInfo markerInfo;
                int index = markers.indexOf(this.focusedMarker);
                this.focusedMarker = markerInfo = markers.get((index + 1) % markers.size());
                Location location = markerInfo.location();
                this.updateMapCenter(location.x, location.z);
            }
        }, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)"screens.wynntils.map.focus.name")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.focus.description1")), Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"screens.wynntils.map.focus.description2")))));
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.width / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6, (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 14, 14, Texture.ADD_ICON, b -> McUtils.mc().setScreen(PoiCreationScreen.create(this)), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.translatable((String)"screens.wynntils.map.waypoints.add.name")), Component.translatable((String)"screens.wynntils.map.waypoints.add.description").withStyle(ChatFormatting.GRAY))));
        if (this.firstInit) {
            BoundingBox textureBoundingBox = BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.width / this.zoomRenderScale, (float)this.height / this.zoomRenderScale);
            if (((Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).centerWhenUnmapped.get()).booleanValue() && Services.Map.getMapsForBoundingBox(textureBoundingBox).isEmpty()) {
                this.centerMapOnWorld();
            }
            this.firstInit = false;
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (this.holdingMapKey && !Managers.Feature.getFeatureInstance(MainMapFeature.class).openMapKeybind.getKeyMapping().isDown()) {
            this.onClose();
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        this.renderMap(guiGraphics);
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        this.renderPois(poseStack, mouseX, mouseY);
        if (Managers.Feature.getFeatureInstance(MappingProgressFeature.class).isEnabled()) {
            this.renderChunkBorders(poseStack);
            BUFFER_SOURCE.endBatch();
        }
        this.renderCursor(poseStack, ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).playerPointerScale.get()).floatValue(), (CustomColor)Managers.Feature.getFeatureInstance(MainMapFeature.class).pointerColor.get(), (PointerType)((Object)Managers.Feature.getFeatureInstance(MainMapFeature.class).pointerType.get()));
        LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
        if (currentLootrun != null) {
            MapRenderer.renderLootrunLine(currentLootrun, 2.0f, 3.0f, poseStack, this.centerX, this.centerZ, this.mapCenterX, this.mapCenterZ, this.zoomRenderScale, CommonColors.LIGHT_BLUE.asInt(), CommonColors.BLACK.asInt());
        }
        RenderUtils.disableScissor(guiGraphics);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderCoordinates(poseStack, mouseX, mouseY);
        this.renderZoomWidget(poseStack, mouseX, mouseY);
        this.renderMapButtons(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderPois(PoseStack poseStack, int mouseX, int mouseY) {
        Stream<Poi> pois = Services.Poi.getServicePois();
        pois = Stream.concat(pois, Services.Poi.getCombatPois());
        pois = Stream.concat(pois, Services.Poi.getLabelPois());
        pois = Stream.concat(pois, ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream());
        pois = Stream.concat(pois, Services.Poi.getProvidedCustomPois().stream());
        pois = Stream.concat(pois, Models.Marker.getAllPois());
        pois = Stream.concat(pois, this.getPlayerPois((Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).renderRemotePartyPlayers.get(), (Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).renderRemoteFriendPlayers.get(), (Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).renderRemoteGuildPlayers.get()));
        if (this.showTerrs) {
            pois = Stream.concat(pois, Models.Territory.getTerritoryPois().stream());
        }
        this.renderPois(pois.collect(Collectors.toList()), poseStack, BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.width / this.zoomRenderScale, (float)this.height / this.zoomRenderScale), ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).poiScale.get()).floatValue(), mouseX, mouseY);
    }

    private Stream<PlayerMainMapPoi> getPlayerPois(boolean renderRemotePartyPlayers, boolean renderRemoteFriendPlayers, boolean renderRemoteGuildPlayers) {
        return Services.Hades.getHadesUsers().filter(hadesUser -> hadesUser.getRelation() == PlayerRelation.PARTY && renderRemotePartyPlayers || hadesUser.getRelation() == PlayerRelation.FRIEND && renderRemoteFriendPlayers || hadesUser.getRelation() == PlayerRelation.GUILD && renderRemoteGuildPlayers).map(PlayerMainMapPoi::new);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.showTerrs = (Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).holdGuildMapOpen.get() != false ? true : !this.showTerrs;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341 && ((Boolean)Managers.Feature.getFeatureInstance(MainMapFeature.class).holdGuildMapOpen.get()).booleanValue()) {
            this.showTerrs = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY)) continue;
            child.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        if (button == 1) {
            List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
            if (KeyboardUtils.isShiftDown() && !markers.isEmpty()) {
                MarkerInfo markerInfo;
                int index = markers.indexOf(this.focusedMarker);
                this.focusedMarker = markerInfo = markers.get((index + 1) % markers.size());
                Location location = markerInfo.location();
                this.updateMapCenter(location.x, location.z);
                return true;
            }
            this.centerMapAroundPlayer();
        } else if (button == 0) {
            if (this.hovered instanceof WaypointPoi) {
                MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(this.hovered.getLocation().asLocation());
                return true;
            }
            if (this.hovered != null && !(this.hovered instanceof TerritoryPoi)) {
                McUtils.playSoundUI(SoundEvents.EXPERIENCE_ORB_PICKUP);
                if (!KeyboardUtils.isShiftDown()) {
                    MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
                }
                if (this.hovered.hasStaticLocation()) {
                    Poi index = this.hovered;
                    if (index instanceof IconPoi) {
                        IconPoi iconPoi = (IconPoi)index;
                        if (iconPoi instanceof CustomPoi) {
                            customPoi = (CustomPoi)iconPoi;
                            MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(this.hovered.getLocation()), iconPoi.getIcon(), ((CustomPoi)customPoi).getColor(), ((CustomPoi)customPoi).getColor(), this.hovered.getName());
                        } else {
                            MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(this.hovered.getLocation()), iconPoi.getIcon(), this.hovered.getName());
                        }
                    } else {
                        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(this.hovered.getLocation()), this.hovered.getName());
                    }
                } else {
                    Poi finalHovered = this.hovered;
                    MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new DynamicLocationSupplier(() -> finalHovered.getLocation().asLocation()), finalHovered.getName());
                }
                return true;
            }
        } else if (button == 2) {
            if (KeyboardUtils.isShiftDown()) {
                customPoi = this.hovered;
                if (customPoi instanceof CustomPoi && !Services.Poi.isPoiProvided(customPoi = (CustomPoi)customPoi)) {
                    McUtils.mc().setScreen(PoiCreationScreen.create(this, customPoi));
                } else {
                    int gameX = (int)((mouseX - (double)this.centerX) / (double)this.zoomRenderScale + (double)this.mapCenterX);
                    int gameZ = (int)((mouseY - (double)this.centerZ) / (double)this.zoomRenderScale + (double)this.mapCenterZ);
                    McUtils.mc().setScreen(PoiCreationScreen.create(this, new Location(gameX, 0, gameZ)));
                }
            } else if (KeyboardUtils.isAltDown()) {
                Poi gameX = this.hovered;
                if (gameX instanceof CustomPoi && !Services.Poi.isPoiProvided(customPoi = (CustomPoi)gameX)) {
                    HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
                    ((List)customPois.get()).remove(customPoi);
                    customPois.touched();
                }
            } else {
                this.setCompassToMouseCoords(mouseX, mouseY, true);
                return true;
            }
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    private void shareLocationOrCompass(int button) {
        List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
        boolean shareCompass = KeyboardUtils.isShiftDown() && !markers.isEmpty();
        String target = null;
        if (button == 0) {
            target = "guild";
        } else if (button == 1) {
            target = "party";
        }
        if (target == null) {
            return;
        }
        if (shareCompass) {
            LocationUtils.shareCompass(target, markers.getFirst().location());
        } else {
            LocationUtils.shareLocation(target);
        }
    }

    public void setHovered(Poi hovered) {
        this.hovered = hovered;
    }
}

